/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;

public class CalibratedPoseAndPoint {
    private int numViews;
    private int numPoints;
    private boolean[] viewKnown = new boolean[0];
    private Se3_F64[] worldToCamera = new Se3_F64[0];
    private Point3D_F64[] points = new Point3D_F64[0];

    public void configure(int numViews, int numPoints) {
        int i;
        Se3_F64[] temp;
        if (this.worldToCamera.length < numViews) {
            temp = new Se3_F64[numViews];
            System.arraycopy(this.worldToCamera, 0, temp, 0, this.worldToCamera.length);
            for (i = this.worldToCamera.length; i < temp.length; ++i) {
                temp[i] = new Se3_F64();
            }
            this.worldToCamera = temp;
            this.viewKnown = new boolean[numViews];
        }
        if (this.points.length < numPoints) {
            temp = new Point3D_F64[numPoints];
            System.arraycopy(this.points, 0, temp, 0, this.points.length);
            for (i = this.points.length; i < temp.length; ++i) {
                temp[i] = new Point3D_F64();
            }
            this.points = temp;
        }
        this.numPoints = numPoints;
        this.numViews = numViews;
        for (int i2 = 0; i2 < numViews; ++i2) {
            this.viewKnown[i2] = false;
        }
    }

    public void setViewKnown(int view, boolean known) {
        this.viewKnown[view] = known;
    }

    public boolean isViewKnown(int view) {
        return this.viewKnown[view];
    }

    public Se3_F64 getWorldToCamera(int view) {
        return this.worldToCamera[view];
    }

    public Point3D_F64 getPoint(int index) {
        return this.points[index];
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public int getNumViews() {
        return this.numViews;
    }

    public int getNumUnknownViews() {
        int ret = 0;
        for (int i = 0; i < this.numViews; ++i) {
            if (this.viewKnown[i]) continue;
            ++ret;
        }
        return ret;
    }

    public boolean[] getKnownArray() {
        return this.viewKnown;
    }
}

