/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import georegression.geometry.RotationMatrixGenerator;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class PnPRodriguesCodec
implements ModelCodec<Se3_F64> {
    SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)false);
    DenseMatrix64F R = new DenseMatrix64F(3, 3);
    Rodrigues_F64 rotation = new Rodrigues_F64();

    public void decode(double[] input, Se3_F64 outputModel) {
        this.rotation.setParamVector(input[0], input[1], input[2]);
        RotationMatrixGenerator.rodriguesToMatrix((Rodrigues_F64)this.rotation, (DenseMatrix64F)outputModel.getR());
        Vector3D_F64 T = outputModel.getT();
        T.x = input[3];
        T.y = input[4];
        T.z = input[5];
    }

    public void encode(Se3_F64 input, double[] output) {
        if (!this.svd.decompose((Matrix)input.getR())) {
            throw new RuntimeException("SVD failed");
        }
        DenseMatrix64F U = (DenseMatrix64F)this.svd.getU(null, false);
        DenseMatrix64F V = (DenseMatrix64F)this.svd.getV(null, false);
        CommonOps.multTransB((RowD1Matrix64F)U, (RowD1Matrix64F)V, (RowD1Matrix64F)this.R);
        RotationMatrixGenerator.matrixToRodrigues((DenseMatrix64F)this.R, (Rodrigues_F64)this.rotation);
        output[0] = this.rotation.unitAxisRotation.x * this.rotation.theta;
        output[1] = this.rotation.unitAxisRotation.y * this.rotation.theta;
        output[2] = this.rotation.unitAxisRotation.z * this.rotation.theta;
        Vector3D_F64 T = input.getT();
        output[3] = T.x;
        output[4] = T.y;
        output[5] = T.z;
    }

    public int getParamLength() {
        return 6;
    }
}

