/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.BundleAdjustmentCalibrated;
import boofcv.alg.geo.bundle.CalibPoseAndPointResiduals;
import boofcv.alg.geo.bundle.CalibPoseAndPointRodriguesCodec;
import boofcv.alg.geo.bundle.CalibPoseAndPointRodriguesJacobian;
import boofcv.alg.geo.bundle.CalibratedPoseAndPoint;
import boofcv.alg.geo.bundle.ViewPointObservations;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.RegionStepType;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;

public class BundleAdjustmentCalibratedDense
implements BundleAdjustmentCalibrated {
    CalibPoseAndPointRodriguesCodec codec;
    double[] param = new double[0];
    UnconstrainedLeastSquares minimizer;
    CalibPoseAndPointResiduals func = new CalibPoseAndPointResiduals();
    CalibPoseAndPointRodriguesJacobian jacobian = new CalibPoseAndPointRodriguesJacobian();
    int maxIterations;
    double convergenceTol;

    public BundleAdjustmentCalibratedDense(double convergenceTol, int maxIterations) {
        this.convergenceTol = convergenceTol;
        this.minimizer = FactoryOptimization.leastSquaresTrustRegion((double)1.0, (RegionStepType)RegionStepType.DOG_LEG_F, (boolean)false);
        this.codec = new CalibPoseAndPointRodriguesCodec();
        this.maxIterations = maxIterations;
    }

    @Override
    public boolean process(CalibratedPoseAndPoint initialModel, List<ViewPointObservations> observations) {
        int i;
        int numViews = initialModel.getNumViews();
        int numPoints = initialModel.getNumPoints();
        int numViewsUnknown = initialModel.getNumUnknownViews();
        this.codec.configure(numViews, numPoints, numViewsUnknown, initialModel.getKnownArray());
        if (this.param.length < this.codec.getParamLength()) {
            this.param = new double[this.codec.getParamLength()];
        }
        boolean[] known = initialModel.getKnownArray();
        Se3_F64[] extrinsic = new Se3_F64[initialModel.getNumViews()];
        for (i = 0; i < extrinsic.length; ++i) {
            if (!known[i]) continue;
            extrinsic[i] = new Se3_F64();
            extrinsic[i].set(initialModel.getWorldToCamera(i));
        }
        this.codec.encode(initialModel, this.param);
        this.func.configure(this.codec, initialModel, observations);
        this.jacobian.configure(observations, initialModel.getNumPoints(), extrinsic);
        this.minimizer.setFunction((FunctionNtoM)this.func, (FunctionNtoMxN)this.jacobian);
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)observations.size());
        for (i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        this.codec.decode(this.minimizer.getParameters(), initialModel);
        return true;
    }
}

