/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.radtan;

import boofcv.alg.distort.radtan.RadialTangential_F64;
import boofcv.struct.distort.PointTransform_F64;
import georegression.struct.point.Point2D_F64;

public class RemoveRadialNtoN_F64
implements PointTransform_F64 {
    protected RadialTangential_F64 params;
    protected double sum;
    protected double tx;
    protected double ty;
    private double tol = 1.0E-10;

    public RemoveRadialNtoN_F64() {
    }

    public RemoveRadialNtoN_F64(double tol) {
        this.tol = tol;
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }

    public RemoveRadialNtoN_F64 setDistortion(double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F64(radial, t1, t2);
        return this;
    }

    public void compute(double x, double y, Point2D_F64 out) {
        double[] radial = this.params.radial;
        double t1 = this.params.t1;
        double t2 = this.params.t2;
        double origX = x;
        double origY = y;
        double prevSum = 0.0;
        for (int iter = 0; iter < 20; ++iter) {
            double r2;
            double ri2 = r2 = x * x + y * y;
            this.sum = 0.0;
            for (int i = 0; i < radial.length; ++i) {
                this.sum += radial[i] * ri2;
                ri2 *= r2;
            }
            this.tx = 2.0 * t1 * x * y + t2 * (r2 + 2.0 * x * x);
            this.ty = t1 * (r2 + 2.0 * y * y) + 2.0 * t2 * x * y;
            x = (origX - this.tx) / (1.0 + this.sum);
            y = (origY - this.ty) / (1.0 + this.sum);
            if (Math.abs(prevSum - this.sum) <= this.tol) break;
            prevSum = this.sum;
        }
        out.set(x, y);
    }
}

