/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.distort.LensDistortionOps;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PointTransform_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;

public class WorldToCameraToPixel {
    private Se3_F64 worldToCamera;
    private Point3D_F64 cameraPt = new Point3D_F64();
    private PointTransform_F64 normToPixel;

    public void configure(IntrinsicParameters intrinsic, Se3_F64 worldToCamera) {
        this.worldToCamera = worldToCamera;
        this.normToPixel = LensDistortionOps.transformPoint(intrinsic).distort_F64(false, true);
    }

    public boolean transform(Point3D_F64 worldPt, Point2D_F64 pixelPt) {
        SePointOps_F64.transform((Se3_F64)this.worldToCamera, (Point3D_F64)worldPt, (Point3D_F64)this.cameraPt);
        if (this.cameraPt.z <= 0.0) {
            return false;
        }
        this.normToPixel.compute(this.cameraPt.x / this.cameraPt.z, this.cameraPt.y / this.cameraPt.z, pixelPt);
        return true;
    }

    public Point2D_F64 transform(Point3D_F64 worldPt) {
        Point2D_F64 out = new Point2D_F64();
        if (this.transform(worldPt, out)) {
            return out;
        }
        return null;
    }
}

