/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.tracker;

import boofcv.abst.feature.associate.AssociateDescTo2D;
import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.ScoreAssociateHamming_B;
import boofcv.abst.feature.associate.ScoreAssociateNccFeature;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.associate.WrapAssociateSurfBasic;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.describe.WrapDescribeBrief;
import boofcv.abst.feature.describe.WrapDescribePixelRegionNCC;
import boofcv.abst.feature.detdesc.DetectDescribeFusion;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigFast;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.orientation.ConfigAverageIntegral;
import boofcv.abst.feature.orientation.ConfigSlidingIntegral;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.abst.feature.orientation.RegionOrientation;
import boofcv.abst.feature.tracker.DdaManagerDetectDescribePoint;
import boofcv.abst.feature.tracker.DdaManagerGeneralPoint;
import boofcv.abst.feature.tracker.DetectDescribeAssociate;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.feature.tracker.PointTrackerCombined;
import boofcv.abst.feature.tracker.PointTrackerKltPyramid;
import boofcv.abst.filter.blur.BlurFilter;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.associate.AssociateSurfBasic;
import boofcv.alg.feature.describe.DescribePointBrief;
import boofcv.alg.feature.describe.DescribePointPixelRegionNCC;
import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.alg.feature.describe.brief.FactoryBriefDefinition;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.intensity.ShiTomasiCornerIntensity;
import boofcv.alg.feature.detect.interest.EasyGeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.combined.CombinedTrackerScalePoint;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryDescribePointAlgs;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.factory.feature.orientation.FactoryOrientation;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.factory.tracker.FactoryTrackerAlg;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidDiscrete;
import java.util.Random;

public class FactoryPointTracker {
    public static <I extends ImageGray, D extends ImageGray> PointTracker<I> klt(int[] scaling, ConfigGeneralDetector configExtract, int featureRadius, Class<I> imageType, Class<D> derivType) {
        PkltConfig config = new PkltConfig();
        config.pyramidScaling = scaling;
        config.templateRadius = featureRadius;
        return FactoryPointTracker.klt(config, configExtract, imageType, derivType);
    }

    public static <I extends ImageGray, D extends ImageGray> PointTracker<I> klt(PkltConfig config, ConfigGeneralDetector configExtract, Class<I> imageType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        if (config == null) {
            config = new PkltConfig();
        }
        if (configExtract == null) {
            configExtract = new ConfigGeneralDetector();
        }
        GeneralFeatureDetector<I, D> detector = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        InterpolateRectangle interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle interpDeriv = FactoryInterpolation.bilinearRectangle((Class)derivType);
        ImageGradient gradient = FactoryDerivative.sobel(imageType, (Class)derivType);
        PyramidDiscrete pyramid = FactoryPyramid.discreteGaussian((int[])config.pyramidScaling, (double)-1.0, (int)2, (boolean)true, imageType);
        return new PointTrackerKltPyramid<I, D>(config.config, config.templateRadius, pyramid, detector, gradient, interpInput, interpDeriv, derivType);
    }

    public static <I extends ImageGray> PointTracker<I> dda_FH_SURF_Fast(ConfigFastHessian configDetector, ConfigSurfDescribe.Speed configDescribe, ConfigAverageIntegral configOrientation, Class<I> imageType) {
        ScoreAssociation score = FactoryAssociation.scoreEuclidean(TupleDesc_F64.class, (boolean)true);
        AssociateSurfBasic assoc = new AssociateSurfBasic(FactoryAssociation.greedy((ScoreAssociation)score, (double)5.0, (boolean)true));
        AssociateDescTo2D generalAssoc = new AssociateDescTo2D((AssociateDescription)new WrapAssociateSurfBasic(assoc));
        DetectDescribePoint fused = FactoryDetectDescribe.surfFast((ConfigFastHessian)configDetector, (ConfigSurfDescribe.Speed)configDescribe, (ConfigAverageIntegral)configOrientation, imageType);
        DdaManagerDetectDescribePoint manager = new DdaManagerDetectDescribePoint(fused);
        return new DetectDescribeAssociate(manager, generalAssoc, false);
    }

    public static <I extends ImageGray> PointTracker<I> dda_FH_SURF_Stable(ConfigFastHessian configDetector, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, Class<I> imageType) {
        ScoreAssociation score = FactoryAssociation.scoreEuclidean(TupleDesc_F64.class, (boolean)true);
        AssociateSurfBasic assoc = new AssociateSurfBasic(FactoryAssociation.greedy((ScoreAssociation)score, (double)5.0, (boolean)true));
        AssociateDescTo2D generalAssoc = new AssociateDescTo2D((AssociateDescription)new WrapAssociateSurfBasic(assoc));
        DetectDescribePoint fused = FactoryDetectDescribe.surfStable((ConfigFastHessian)configDetector, (ConfigSurfDescribe.Stability)configDescribe, (ConfigSlidingIntegral)configOrientation, imageType);
        DdaManagerDetectDescribePoint manager = new DdaManagerDetectDescribePoint(fused);
        return new DetectDescribeAssociate(manager, generalAssoc, false);
    }

    public static <I extends ImageGray, D extends ImageGray> PointTracker<I> dda_ST_BRIEF(int maxAssociationError, ConfigGeneralDetector configExtract, Class<I> imageType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        DescribePointBrief brief = FactoryDescribePointAlgs.brief((BinaryCompareDefinition_I32)FactoryBriefDefinition.gaussian2((Random)new Random(123L), (int)16, (int)512), (BlurFilter)FactoryBlurFilter.gaussian(imageType, (double)0.0, (int)4));
        GeneralFeatureDetector<I, D> detectPoint = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        EasyGeneralFeatureDetector easy = new EasyGeneralFeatureDetector(detectPoint, imageType, derivType);
        ScoreAssociateHamming_B score = new ScoreAssociateHamming_B();
        AssociateDescTo2D association = new AssociateDescTo2D(FactoryAssociation.greedy((ScoreAssociation)score, (double)maxAssociationError, (boolean)true));
        DdaManagerGeneralPoint manager = new DdaManagerGeneralPoint(easy, new WrapDescribeBrief(brief, imageType), 1.0);
        return new DetectDescribeAssociate(manager, association, false);
    }

    public static <I extends ImageGray, D extends ImageGray> PointTracker<I> dda_FAST_BRIEF(ConfigFast configFast, ConfigGeneralDetector configExtract, int maxAssociationError, Class<I> imageType) {
        DescribePointBrief brief = FactoryDescribePointAlgs.brief((BinaryCompareDefinition_I32)FactoryBriefDefinition.gaussian2((Random)new Random(123L), (int)16, (int)512), (BlurFilter)FactoryBlurFilter.gaussian(imageType, (double)0.0, (int)4));
        GeneralFeatureDetector corner = FactoryDetectPoint.createFast((ConfigFast)configFast, (ConfigGeneralDetector)configExtract, imageType);
        EasyGeneralFeatureDetector easy = new EasyGeneralFeatureDetector(corner, imageType, null);
        ScoreAssociateHamming_B score = new ScoreAssociateHamming_B();
        AssociateDescTo2D association = new AssociateDescTo2D(FactoryAssociation.greedy((ScoreAssociation)score, (double)maxAssociationError, (boolean)true));
        DdaManagerGeneralPoint manager = new DdaManagerGeneralPoint(easy, new WrapDescribeBrief(brief, imageType), 1.0);
        return new DetectDescribeAssociate(manager, association, false);
    }

    public static <I extends ImageGray, D extends ImageGray> PointTracker<I> dda_ST_NCC(ConfigGeneralDetector configExtract, int describeRadius, Class<I> imageType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        int w = 2 * describeRadius + 1;
        DescribePointPixelRegionNCC alg = FactoryDescribePointAlgs.pixelRegionNCC((int)w, (int)w, imageType);
        GeneralFeatureDetector<I, D> corner = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        EasyGeneralFeatureDetector easy = new EasyGeneralFeatureDetector(corner, imageType, derivType);
        ScoreAssociateNccFeature score = new ScoreAssociateNccFeature();
        AssociateDescTo2D association = new AssociateDescTo2D(FactoryAssociation.greedy((ScoreAssociation)score, (double)Double.MAX_VALUE, (boolean)true));
        DdaManagerGeneralPoint manager = new DdaManagerGeneralPoint(easy, new WrapDescribePixelRegionNCC(alg, imageType), 1.0);
        return new DetectDescribeAssociate(manager, association, false);
    }

    public static <I extends ImageGray, Desc extends TupleDesc> DetectDescribeAssociate<I, Desc> dda(InterestPointDetector<I> detector, OrientationImage<I> orientation, DescribeRegionPoint<I, Desc> describe, AssociateDescription2D<Desc> associate, boolean updateDescription) {
        DetectDescribeFusion fused = new DetectDescribeFusion(detector, orientation, describe);
        DdaManagerDetectDescribePoint manager = new DdaManagerDetectDescribePoint(fused);
        DetectDescribeAssociate dat = new DetectDescribeAssociate(manager, associate, updateDescription);
        return dat;
    }

    public static <I extends ImageGray, Desc extends TupleDesc> DetectDescribeAssociate<I, Desc> dda(DetectDescribePoint<I, Desc> detDesc, AssociateDescription2D<Desc> associate, boolean updateDescription) {
        DdaManagerDetectDescribePoint<I, Desc> manager = new DdaManagerDetectDescribePoint<I, Desc>(detDesc);
        DetectDescribeAssociate<I, Desc> dat = new DetectDescribeAssociate<I, Desc>(manager, associate, updateDescription);
        return dat;
    }

    public static <I extends ImageGray> PointTracker<I> combined_FH_SURF_KLT(PkltConfig kltConfig, int reactivateThreshold, ConfigFastHessian configDetector, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, Class<I> imageType) {
        ScoreAssociation score = FactoryAssociation.defaultScore(TupleDesc_F64.class);
        AssociateSurfBasic assoc = new AssociateSurfBasic(FactoryAssociation.greedy((ScoreAssociation)score, (double)100000.0, (boolean)true));
        WrapAssociateSurfBasic generalAssoc = new WrapAssociateSurfBasic(assoc);
        DetectDescribePoint fused = FactoryDetectDescribe.surfStable((ConfigFastHessian)configDetector, (ConfigSurfDescribe.Stability)configDescribe, (ConfigSlidingIntegral)configOrientation, imageType);
        return FactoryPointTracker.combined(fused, generalAssoc, kltConfig, reactivateThreshold, imageType);
    }

    public static <I extends ImageGray, D extends ImageGray> PointTracker<I> combined_ST_SURF_KLT(ConfigGeneralDetector configExtract, PkltConfig kltConfig, int reactivateThreshold, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, Class<I> imageType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        GeneralFeatureDetector<I, D> corner = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        InterestPointDetector detector = FactoryInterestPoint.wrapPoint(corner, (double)1.0, imageType, (Class)derivType);
        DescribeRegionPoint regionDesc = FactoryDescribeRegionPoint.surfStable((ConfigSurfDescribe.Stability)configDescribe, imageType);
        ScoreAssociation score = FactoryAssociation.scoreEuclidean(TupleDesc_F64.class, (boolean)true);
        AssociateSurfBasic assoc = new AssociateSurfBasic(FactoryAssociation.greedy((ScoreAssociation)score, (double)100000.0, (boolean)true));
        WrapAssociateSurfBasic generalAssoc = new WrapAssociateSurfBasic(assoc);
        OrientationImage orientation = null;
        if (configOrientation != null) {
            Class integralType = GIntegralImageOps.getIntegralType(imageType);
            OrientationIntegral orientationII = FactoryOrientationAlgs.sliding_ii((ConfigSlidingIntegral)configOrientation, (Class)integralType);
            orientation = FactoryOrientation.convertImage((RegionOrientation)orientationII, imageType);
        }
        return FactoryPointTracker.combined(detector, orientation, regionDesc, generalAssoc, kltConfig, reactivateThreshold, imageType);
    }

    public static <I extends ImageGray, Desc extends TupleDesc> PointTracker<I> combined(InterestPointDetector<I> detector, OrientationImage<I> orientation, DescribeRegionPoint<I, Desc> describe, AssociateDescription<Desc> associate, PkltConfig kltConfig, int reactivateThreshold, Class<I> imageType) {
        DetectDescribeFusion fused = new DetectDescribeFusion(detector, orientation, describe);
        return FactoryPointTracker.combined(fused, associate, kltConfig, reactivateThreshold, imageType);
    }

    public static <I extends ImageGray, D extends ImageGray, Desc extends TupleDesc> PointTracker<I> combined(DetectDescribePoint<I, Desc> detector, AssociateDescription<Desc> associate, PkltConfig kltConfig, int reactivateThreshold, Class<I> imageType) {
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        if (kltConfig == null) {
            kltConfig = new PkltConfig();
        }
        CombinedTrackerScalePoint tracker = FactoryTrackerAlg.combined(detector, associate, (PkltConfig)kltConfig, imageType, (Class)derivType);
        return new PointTrackerCombined(tracker, reactivateThreshold, imageType, derivType);
    }

    public static <I extends ImageGray, D extends ImageGray, Desc extends TupleDesc> PointTracker<I> dda(GeneralFeatureDetector<I, D> detector, DescribeRegionPoint<I, Desc> describe, AssociateDescription2D<Desc> associate, double scale, Class<I> imageType) {
        EasyGeneralFeatureDetector easy = new EasyGeneralFeatureDetector(detector, imageType, null);
        DdaManagerGeneralPoint manager = new DdaManagerGeneralPoint(easy, describe, scale);
        return new DetectDescribeAssociate(manager, associate, false);
    }

    public static <I extends ImageGray, D extends ImageGray> GeneralFeatureDetector<I, D> createShiTomasi(ConfigGeneralDetector config, Class<D> derivType) {
        ShiTomasiCornerIntensity cornerIntensity = FactoryIntensityPointAlg.shiTomasi((int)1, (boolean)false, derivType);
        return FactoryDetectPoint.createGeneral((GradientCornerIntensity)cornerIntensity, (ConfigGeneralDetector)config);
    }
}

