/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.denoise;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.alg.denoise.DenoiseWavelet;
import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageSingleBand;

public class WaveletDenoiseFilter<T extends ImageSingleBand>
implements FilterImageInterface<T, T> {
    private WaveletTransform<T, ImageSingleBand, ?> wavelet;
    private DenoiseWavelet alg;
    private ImageSingleBand transform;

    public WaveletDenoiseFilter(WaveletTransform<T, ?, ?> wavelet, DenoiseWavelet denoiser) {
        this.wavelet = wavelet;
        this.alg = denoiser;
    }

    @Override
    public void process(T original, T denoised) {
        if (this.transform != null) {
            ImageDimension d = UtilWavelet.transformDimension(original, this.wavelet.getLevels());
            this.transform.reshape(d.width, d.height);
        }
        this.transform = this.wavelet.transform((ImageSingleBand)original, this.transform);
        this.alg.denoise(this.transform, this.wavelet.getLevels());
        this.wavelet.invert(this.transform, (ImageSingleBand)denoised);
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public Class<T> getInputType() {
        return this.wavelet.getOriginalType();
    }
}

