/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.convolve;

import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.core.image.border.BorderType;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageSingleBand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GenericConvolveDown<Input extends ImageSingleBand, Output extends ImageSingleBand>
implements ConvolveInterface<Input, Output> {
    Method m;
    KernelBase kernel;
    BorderType type;
    int skip;
    Class<Input> imageType;

    public GenericConvolveDown(Method m, KernelBase kernel, BorderType type, int skip, Class<Input> imageType) {
        this.m = m;
        this.kernel = kernel;
        this.type = type;
        this.skip = skip;
        this.imageType = imageType;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    @Override
    public void process(Input input, Output output) {
        try {
            this.m.invoke(null, this.kernel, input, output, this.skip);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHorizontalBorder() {
        if (this.type == BorderType.SKIP) {
            return this.kernel.getRadius();
        }
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return this.getHorizontalBorder();
    }

    @Override
    public BorderType getBorderType() {
        return this.type;
    }

    @Override
    public Class<Input> getInputType() {
        return this.imageType;
    }
}

