/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.LinearContourLabelChang2004;
import boofcv.alg.filter.binary.impl.ImplBinaryBorderOps;
import boofcv.alg.filter.binary.impl.ImplBinaryInnerOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.FastQueue;

public class BinaryImageOps {
    public static ImageUInt8 logicAnd(ImageUInt8 inputA, ImageUInt8 inputB, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(inputA, inputB);
        output = InputSanityCheck.checkDeclare(inputA, output);
        for (int y = 0; y < inputA.height; ++y) {
            int indexA = inputA.startIndex + y * inputA.stride;
            int indexB = inputB.startIndex + y * inputB.stride;
            int indexOut = output.startIndex + y * output.stride;
            int end = indexA + inputA.width;
            while (indexA < end) {
                byte valA = inputA.data[indexA];
                output.data[indexOut] = valA == 1 && valA == inputB.data[indexB] ? (byte)1 : 0;
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
        return output;
    }

    public static ImageUInt8 logicOr(ImageUInt8 inputA, ImageUInt8 inputB, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(inputA, inputB);
        output = InputSanityCheck.checkDeclare(inputA, output);
        for (int y = 0; y < inputA.height; ++y) {
            int indexA = inputA.startIndex + y * inputA.stride;
            int indexB = inputB.startIndex + y * inputB.stride;
            int indexOut = output.startIndex + y * output.stride;
            int end = indexA + inputA.width;
            while (indexA < end) {
                output.data[indexOut] = inputA.data[indexA] == 1 || 1 == inputB.data[indexB] ? (byte)1 : 0;
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
        return output;
    }

    public static ImageUInt8 logicXor(ImageUInt8 inputA, ImageUInt8 inputB, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(inputA, inputB);
        output = InputSanityCheck.checkDeclare(inputA, output);
        for (int y = 0; y < inputA.height; ++y) {
            int indexA = inputA.startIndex + y * inputA.stride;
            int indexB = inputB.startIndex + y * inputB.stride;
            int indexOut = output.startIndex + y * output.stride;
            int end = indexA + inputA.width;
            while (indexA < end) {
                output.data[indexOut] = inputA.data[indexA] != inputB.data[indexB] ? (byte)1 : 0;
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
        return output;
    }

    public static ImageUInt8 erode4(ImageUInt8 input, ImageUInt8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        ImplBinaryInnerOps.erode4(input, output);
        ImplBinaryBorderOps.erode4(input, output);
        return output;
    }

    public static ImageUInt8 dilate4(ImageUInt8 input, ImageUInt8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        ImplBinaryInnerOps.dilate4(input, output);
        ImplBinaryBorderOps.dilate4(input, output);
        return output;
    }

    public static ImageUInt8 edge4(ImageUInt8 input, ImageUInt8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        ImplBinaryInnerOps.edge4(input, output);
        ImplBinaryBorderOps.edge4(input, output);
        return output;
    }

    public static ImageUInt8 erode8(ImageUInt8 input, ImageUInt8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        ImplBinaryInnerOps.erode8(input, output);
        ImplBinaryBorderOps.erode8(input, output);
        return output;
    }

    public static ImageUInt8 dilate8(ImageUInt8 input, ImageUInt8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        ImplBinaryInnerOps.dilate8(input, output);
        ImplBinaryBorderOps.dilate8(input, output);
        return output;
    }

    public static ImageUInt8 edge8(ImageUInt8 input, ImageUInt8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        ImplBinaryInnerOps.edge8(input, output);
        ImplBinaryBorderOps.edge8(input, output);
        return output;
    }

    public static ImageUInt8 removePointNoise(ImageUInt8 input, ImageUInt8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        ImplBinaryInnerOps.removePointNoise(input, output);
        ImplBinaryBorderOps.removePointNoise(input, output);
        return output;
    }

    public static List<Contour> contour(ImageUInt8 input, int rule, ImageSInt32 output) {
        if (output == null) {
            output = new ImageSInt32(input.width, input.height);
        } else {
            InputSanityCheck.checkSameShape(input, output);
        }
        LinearContourLabelChang2004 alg = new LinearContourLabelChang2004(rule);
        alg.process(input, output);
        return alg.getContours().toList();
    }

    public static void relabel(ImageSInt32 input, int[] labels) {
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int val = input.data[index];
                input.data[index] = labels[val];
            }
        }
    }

    public static ImageUInt8 labelToBinary(ImageSInt32 labelImage, ImageUInt8 binaryImage) {
        binaryImage = InputSanityCheck.checkDeclare(labelImage, binaryImage, ImageUInt8.class);
        for (int y = 0; y < labelImage.height; ++y) {
            int indexIn = labelImage.startIndex + y * labelImage.stride;
            int indexOut = binaryImage.startIndex + y * binaryImage.stride;
            int end = indexIn + labelImage.width;
            while (indexIn < end) {
                binaryImage.data[indexOut] = 0 == labelImage.data[indexIn] ? (byte)0 : 1;
                ++indexIn;
                ++indexOut;
            }
        }
        return binaryImage;
    }

    public static ImageUInt8 labelToBinary(ImageSInt32 labelImage, ImageUInt8 binaryImage, boolean[] selectedBlobs) {
        binaryImage = InputSanityCheck.checkDeclare(labelImage, binaryImage, ImageUInt8.class);
        for (int y = 0; y < labelImage.height; ++y) {
            int indexIn = labelImage.startIndex + y * labelImage.stride;
            int indexOut = binaryImage.startIndex + y * binaryImage.stride;
            int end = indexIn + labelImage.width;
            while (indexIn < end) {
                int val = labelImage.data[indexIn];
                binaryImage.data[indexOut] = 0 == val ? (byte)0 : (selectedBlobs[val] ? (byte)1 : 0);
                ++indexIn;
                ++indexOut;
            }
        }
        return binaryImage;
    }

    public static List<List<Point2D_I32>> labelToClusters(ImageSInt32 labelImage, int numLabels, FastQueue<Point2D_I32> queue) {
        ArrayList<List<Point2D_I32>> ret = new ArrayList<List<Point2D_I32>>();
        for (int i = 0; i < numLabels + 1; ++i) {
            ret.add(new ArrayList());
        }
        if (queue == null) {
            queue = new FastQueue(numLabels, Point2D_I32.class, true);
        } else {
            queue.reset();
        }
        for (int y = 0; y < labelImage.height; ++y) {
            int start = labelImage.startIndex + y * labelImage.stride;
            int end = start + labelImage.width;
            for (int index = start; index < end; ++index) {
                int v = labelImage.data[index];
                if (v <= 0) continue;
                Point2D_I32 p = (Point2D_I32)queue.grow();
                p.set(index - start, y);
                ((List)ret.get(v)).add(p);
            }
        }
        if (((List)ret.get(0)).size() != 0) {
            throw new RuntimeException("BUG!");
        }
        ret.remove(0);
        return ret;
    }

    public static void clusterToBinary(List<List<Point2D_I32>> clusters, ImageUInt8 binary) {
        ImageMiscOps.fill(binary, 0);
        for (List<Point2D_I32> l : clusters) {
            for (Point2D_I32 p : l) {
                binary.set(p.x, p.y, 1);
            }
        }
    }

    public static int[] selectRandomColors(int numBlobs, Random rand) {
        int[] colors = new int[numBlobs + 1];
        colors[0] = 0;
        int B = 100;
        for (int i = 1; i < colors.length; ++i) {
            int c;
            while (((c = rand.nextInt(0xFFFFFF)) & 0xFF) <= B && (c >> 8 & 0xFF) <= B && (c >> 8 & 0xFF) <= B) {
            }
            colors[i] = c;
        }
        return colors;
    }
}

