/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.border.ConvolveJustBorder_General;
import boofcv.alg.filter.convolve.noborder.ImplConvolveBox;
import boofcv.core.image.border.ImageBorderValue;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;

public class ConvolveImageBox {
    public static void horizontal(ImageFloat32 input, ImageFloat32 output, int radius, boolean includeBorder) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, false);
        ConvolveJustBorder_General.horizontal(kernel, ImageBorderValue.wrap(input, 0.0f), output, radius);
        ImplConvolveBox.horizontal(input, output, radius, includeBorder);
    }

    public static void horizontal(ImageUInt8 input, ImageInt16 output, int radius, boolean includeBorder) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.horizontal(kernel, ImageBorderValue.wrap(input, 0), output, radius);
        ImplConvolveBox.horizontal(input, output, radius, includeBorder);
    }

    public static void horizontal(ImageUInt8 input, ImageSInt32 output, int radius, boolean includeBorder) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.horizontal(kernel, ImageBorderValue.wrap(input, 0), output, radius);
        ImplConvolveBox.horizontal(input, output, radius, includeBorder);
    }

    public static void horizontal(ImageSInt16 input, ImageInt16 output, int radius, boolean includeBorder) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.horizontal(kernel, ImageBorderValue.wrap(input, 0), output, radius);
        ImplConvolveBox.horizontal(input, output, radius, includeBorder);
    }

    public static void vertical(ImageFloat32 input, ImageFloat32 output, int radius, boolean includeBorder) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, false);
        ConvolveJustBorder_General.vertical(kernel, ImageBorderValue.wrap(input, 0.0f), output, radius);
        ImplConvolveBox.vertical(input, output, radius, includeBorder);
    }

    public static void vertical(ImageUInt8 input, ImageInt16 output, int radius, boolean includeBorder) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.vertical(kernel, ImageBorderValue.wrap(input, 0), output, radius);
        ImplConvolveBox.vertical(input, output, radius, includeBorder);
    }

    public static void vertical(ImageUInt8 input, ImageSInt32 output, int radius, boolean includeBorder) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.vertical(kernel, ImageBorderValue.wrap(input, 0), output, radius);
        ImplConvolveBox.vertical(input, output, radius, includeBorder);
    }

    public static void vertical(ImageSInt16 input, ImageInt16 output, int radius, boolean includeBorder) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.vertical(kernel, ImageBorderValue.wrap(input, 0), output, radius);
        ImplConvolveBox.vertical(input, output, radius, includeBorder);
    }
}

