/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageSInt16;

public class ConvolveImageUnrolled_S16_I16 {
    public static boolean horizontal(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        switch (kernel.width) {
            case 3: {
                ConvolveImageUnrolled_S16_I16.horizontal3(kernel, image, dest, includeBorder);
                break;
            }
            case 5: {
                ConvolveImageUnrolled_S16_I16.horizontal5(kernel, image, dest, includeBorder);
                break;
            }
            case 7: {
                ConvolveImageUnrolled_S16_I16.horizontal7(kernel, image, dest, includeBorder);
                break;
            }
            case 9: {
                ConvolveImageUnrolled_S16_I16.horizontal9(kernel, image, dest, includeBorder);
                break;
            }
            case 11: {
                ConvolveImageUnrolled_S16_I16.horizontal11(kernel, image, dest, includeBorder);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static boolean vertical(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        switch (kernel.width) {
            case 3: {
                ConvolveImageUnrolled_S16_I16.vertical3(kernel, image, dest, includeBorder);
                break;
            }
            case 5: {
                ConvolveImageUnrolled_S16_I16.vertical5(kernel, image, dest, includeBorder);
                break;
            }
            case 7: {
                ConvolveImageUnrolled_S16_I16.vertical7(kernel, image, dest, includeBorder);
                break;
            }
            case 9: {
                ConvolveImageUnrolled_S16_I16.vertical9(kernel, image, dest, includeBorder);
                break;
            }
            case 11: {
                ConvolveImageUnrolled_S16_I16.vertical11(kernel, image, dest, includeBorder);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static boolean convolve(Kernel2D_I32 kernel, ImageSInt16 image, ImageInt16 dest) {
        switch (kernel.width) {
            case 3: {
                ConvolveImageUnrolled_S16_I16.convolve3(kernel, image, dest);
                break;
            }
            case 5: {
                ConvolveImageUnrolled_S16_I16.convolve5(kernel, image, dest);
                break;
            }
            case 7: {
                ConvolveImageUnrolled_S16_I16.convolve7(kernel, image, dest);
                break;
            }
            case 9: {
                ConvolveImageUnrolled_S16_I16.convolve9(kernel, image, dest);
                break;
            }
            case 11: {
                ConvolveImageUnrolled_S16_I16.convolve11(kernel, image, dest);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static void horizontal3(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int k1 = kernel.data[0];
        int k2 = kernel.data[1];
        int k3 = kernel.data[2];
        int radius = kernel.getRadius();
        int yBorder = includeBorder ? 0 : radius;
        int width = image.getWidth();
        int height = image.getHeight() - yBorder;
        for (int i = yBorder; i < height; ++i) {
            int indexDst = dest.startIndex + i * dest.stride + radius;
            int j = image.startIndex + i * image.stride - radius;
            int jEnd = j + width - radius;
            j += radius;
            while (j < jEnd) {
                int indexSrc = j;
                int total = dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc] * k3);
                ++j;
            }
        }
    }

    public static void horizontal5(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int k1 = kernel.data[0];
        int k2 = kernel.data[1];
        int k3 = kernel.data[2];
        int k4 = kernel.data[3];
        int k5 = kernel.data[4];
        int radius = kernel.getRadius();
        int yBorder = includeBorder ? 0 : radius;
        int width = image.getWidth();
        int height = image.getHeight() - yBorder;
        for (int i = yBorder; i < height; ++i) {
            int indexDst = dest.startIndex + i * dest.stride + radius;
            int j = image.startIndex + i * image.stride - radius;
            int jEnd = j + width - radius;
            j += radius;
            while (j < jEnd) {
                int indexSrc = j;
                int total = dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc] * k5);
                ++j;
            }
        }
    }

    public static void horizontal7(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int k1 = kernel.data[0];
        int k2 = kernel.data[1];
        int k3 = kernel.data[2];
        int k4 = kernel.data[3];
        int k5 = kernel.data[4];
        int k6 = kernel.data[5];
        int k7 = kernel.data[6];
        int radius = kernel.getRadius();
        int yBorder = includeBorder ? 0 : radius;
        int width = image.getWidth();
        int height = image.getHeight() - yBorder;
        for (int i = yBorder; i < height; ++i) {
            int indexDst = dest.startIndex + i * dest.stride + radius;
            int j = image.startIndex + i * image.stride - radius;
            int jEnd = j + width - radius;
            j += radius;
            while (j < jEnd) {
                int indexSrc = j;
                int total = dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc] * k7);
                ++j;
            }
        }
    }

    public static void horizontal9(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int k1 = kernel.data[0];
        int k2 = kernel.data[1];
        int k3 = kernel.data[2];
        int k4 = kernel.data[3];
        int k5 = kernel.data[4];
        int k6 = kernel.data[5];
        int k7 = kernel.data[6];
        int k8 = kernel.data[7];
        int k9 = kernel.data[8];
        int radius = kernel.getRadius();
        int yBorder = includeBorder ? 0 : radius;
        int width = image.getWidth();
        int height = image.getHeight() - yBorder;
        for (int i = yBorder; i < height; ++i) {
            int indexDst = dest.startIndex + i * dest.stride + radius;
            int j = image.startIndex + i * image.stride - radius;
            int jEnd = j + width - radius;
            j += radius;
            while (j < jEnd) {
                int indexSrc = j;
                int total = dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                total += dataSrc[indexSrc++] * k7;
                total += dataSrc[indexSrc++] * k8;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc] * k9);
                ++j;
            }
        }
    }

    public static void horizontal11(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int k1 = kernel.data[0];
        int k2 = kernel.data[1];
        int k3 = kernel.data[2];
        int k4 = kernel.data[3];
        int k5 = kernel.data[4];
        int k6 = kernel.data[5];
        int k7 = kernel.data[6];
        int k8 = kernel.data[7];
        int k9 = kernel.data[8];
        int k10 = kernel.data[9];
        int k11 = kernel.data[10];
        int radius = kernel.getRadius();
        int yBorder = includeBorder ? 0 : radius;
        int width = image.getWidth();
        int height = image.getHeight() - yBorder;
        for (int i = yBorder; i < height; ++i) {
            int indexDst = dest.startIndex + i * dest.stride + radius;
            int j = image.startIndex + i * image.stride - radius;
            int jEnd = j + width - radius;
            j += radius;
            while (j < jEnd) {
                int indexSrc = j;
                int total = dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                total += dataSrc[indexSrc++] * k7;
                total += dataSrc[indexSrc++] * k8;
                total += dataSrc[indexSrc++] * k9;
                total += dataSrc[indexSrc++] * k10;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc] * k11);
                ++j;
            }
        }
    }

    public static void vertical3(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int k1 = kernel.data[0];
        int k2 = kernel.data[1];
        int k3 = kernel.data[2];
        int radius = kernel.getRadius();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - radius;
        int xBorder = includeBorder ? 0 : radius;
        for (int y = radius; y < yEnd; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + xBorder;
            int i = image.startIndex + (y - radius) * image.stride;
            int iEnd = i + imgWidth - xBorder;
            i += xBorder;
            while (i < iEnd) {
                int indexSrc = i;
                int total = dataSrc[indexSrc] * k1;
                total += dataSrc[indexSrc += image.stride] * k2;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc += image.stride] * k3);
                ++i;
            }
        }
    }

    public static void vertical5(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int k1 = kernel.data[0];
        int k2 = kernel.data[1];
        int k3 = kernel.data[2];
        int k4 = kernel.data[3];
        int k5 = kernel.data[4];
        int radius = kernel.getRadius();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - radius;
        int xBorder = includeBorder ? 0 : radius;
        for (int y = radius; y < yEnd; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + xBorder;
            int i = image.startIndex + (y - radius) * image.stride;
            int iEnd = i + imgWidth - xBorder;
            i += xBorder;
            while (i < iEnd) {
                int indexSrc = i;
                int total = dataSrc[indexSrc] * k1;
                total += dataSrc[indexSrc += image.stride] * k2;
                total += dataSrc[indexSrc += image.stride] * k3;
                total += dataSrc[indexSrc += image.stride] * k4;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc += image.stride] * k5);
                ++i;
            }
        }
    }

    public static void vertical7(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int k1 = kernel.data[0];
        int k2 = kernel.data[1];
        int k3 = kernel.data[2];
        int k4 = kernel.data[3];
        int k5 = kernel.data[4];
        int k6 = kernel.data[5];
        int k7 = kernel.data[6];
        int radius = kernel.getRadius();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - radius;
        int xBorder = includeBorder ? 0 : radius;
        for (int y = radius; y < yEnd; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + xBorder;
            int i = image.startIndex + (y - radius) * image.stride;
            int iEnd = i + imgWidth - xBorder;
            i += xBorder;
            while (i < iEnd) {
                int indexSrc = i;
                int total = dataSrc[indexSrc] * k1;
                total += dataSrc[indexSrc += image.stride] * k2;
                total += dataSrc[indexSrc += image.stride] * k3;
                total += dataSrc[indexSrc += image.stride] * k4;
                total += dataSrc[indexSrc += image.stride] * k5;
                total += dataSrc[indexSrc += image.stride] * k6;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc += image.stride] * k7);
                ++i;
            }
        }
    }

    public static void vertical9(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int k1 = kernel.data[0];
        int k2 = kernel.data[1];
        int k3 = kernel.data[2];
        int k4 = kernel.data[3];
        int k5 = kernel.data[4];
        int k6 = kernel.data[5];
        int k7 = kernel.data[6];
        int k8 = kernel.data[7];
        int k9 = kernel.data[8];
        int radius = kernel.getRadius();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - radius;
        int xBorder = includeBorder ? 0 : radius;
        for (int y = radius; y < yEnd; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + xBorder;
            int i = image.startIndex + (y - radius) * image.stride;
            int iEnd = i + imgWidth - xBorder;
            i += xBorder;
            while (i < iEnd) {
                int indexSrc = i;
                int total = dataSrc[indexSrc] * k1;
                total += dataSrc[indexSrc += image.stride] * k2;
                total += dataSrc[indexSrc += image.stride] * k3;
                total += dataSrc[indexSrc += image.stride] * k4;
                total += dataSrc[indexSrc += image.stride] * k5;
                total += dataSrc[indexSrc += image.stride] * k6;
                total += dataSrc[indexSrc += image.stride] * k7;
                total += dataSrc[indexSrc += image.stride] * k8;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc += image.stride] * k9);
                ++i;
            }
        }
    }

    public static void vertical11(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, boolean includeBorder) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int k1 = kernel.data[0];
        int k2 = kernel.data[1];
        int k3 = kernel.data[2];
        int k4 = kernel.data[3];
        int k5 = kernel.data[4];
        int k6 = kernel.data[5];
        int k7 = kernel.data[6];
        int k8 = kernel.data[7];
        int k9 = kernel.data[8];
        int k10 = kernel.data[9];
        int k11 = kernel.data[10];
        int radius = kernel.getRadius();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - radius;
        int xBorder = includeBorder ? 0 : radius;
        for (int y = radius; y < yEnd; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + xBorder;
            int i = image.startIndex + (y - radius) * image.stride;
            int iEnd = i + imgWidth - xBorder;
            i += xBorder;
            while (i < iEnd) {
                int indexSrc = i;
                int total = dataSrc[indexSrc] * k1;
                total += dataSrc[indexSrc += image.stride] * k2;
                total += dataSrc[indexSrc += image.stride] * k3;
                total += dataSrc[indexSrc += image.stride] * k4;
                total += dataSrc[indexSrc += image.stride] * k5;
                total += dataSrc[indexSrc += image.stride] * k6;
                total += dataSrc[indexSrc += image.stride] * k7;
                total += dataSrc[indexSrc += image.stride] * k8;
                total += dataSrc[indexSrc += image.stride] * k9;
                total += dataSrc[indexSrc += image.stride] * k10;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc += image.stride] * k11);
                ++i;
            }
        }
    }

    public static void convolve3(Kernel2D_I32 kernel, ImageSInt16 src, ImageInt16 dest) {
        int kernelRadius;
        short[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.getRadius(); y < height - kernelRadius; ++y) {
            int k1 = kernel.data[0];
            int k2 = kernel.data[1];
            int k3 = kernel.data[2];
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            int indexSrcRow = src.startIndex + (y - kernelRadius) * src.stride - kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int indexSrc = indexSrcRow + x;
                int total = 0;
                total += dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc] * k3);
            }
            for (int i = 1; i < 3; ++i) {
                indexDst = dest.startIndex + y * dest.stride + kernelRadius;
                indexSrcRow = src.startIndex + (y + i - kernelRadius) * src.stride - kernelRadius;
                k1 = kernel.data[i * 3 + 0];
                k2 = kernel.data[i * 3 + 1];
                k3 = kernel.data[i * 3 + 2];
                for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                    int indexSrc = indexSrcRow + x;
                    int total = 0;
                    total += dataSrc[indexSrc++] * k1;
                    total += dataSrc[indexSrc++] * k2;
                    int n = indexDst++;
                    dataDst[n] = (short)(dataDst[n] + (short)(total += dataSrc[indexSrc] * k3));
                }
            }
        }
    }

    public static void convolve5(Kernel2D_I32 kernel, ImageSInt16 src, ImageInt16 dest) {
        int kernelRadius;
        short[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.getRadius(); y < height - kernelRadius; ++y) {
            int k1 = kernel.data[0];
            int k2 = kernel.data[1];
            int k3 = kernel.data[2];
            int k4 = kernel.data[3];
            int k5 = kernel.data[4];
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            int indexSrcRow = src.startIndex + (y - kernelRadius) * src.stride - kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int indexSrc = indexSrcRow + x;
                int total = 0;
                total += dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc] * k5);
            }
            for (int i = 1; i < 5; ++i) {
                indexDst = dest.startIndex + y * dest.stride + kernelRadius;
                indexSrcRow = src.startIndex + (y + i - kernelRadius) * src.stride - kernelRadius;
                k1 = kernel.data[i * 5 + 0];
                k2 = kernel.data[i * 5 + 1];
                k3 = kernel.data[i * 5 + 2];
                k4 = kernel.data[i * 5 + 3];
                k5 = kernel.data[i * 5 + 4];
                for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                    int indexSrc = indexSrcRow + x;
                    int total = 0;
                    total += dataSrc[indexSrc++] * k1;
                    total += dataSrc[indexSrc++] * k2;
                    total += dataSrc[indexSrc++] * k3;
                    total += dataSrc[indexSrc++] * k4;
                    int n = indexDst++;
                    dataDst[n] = (short)(dataDst[n] + (short)(total += dataSrc[indexSrc] * k5));
                }
            }
        }
    }

    public static void convolve7(Kernel2D_I32 kernel, ImageSInt16 src, ImageInt16 dest) {
        int kernelRadius;
        short[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.getRadius(); y < height - kernelRadius; ++y) {
            int k1 = kernel.data[0];
            int k2 = kernel.data[1];
            int k3 = kernel.data[2];
            int k4 = kernel.data[3];
            int k5 = kernel.data[4];
            int k6 = kernel.data[5];
            int k7 = kernel.data[6];
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            int indexSrcRow = src.startIndex + (y - kernelRadius) * src.stride - kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int indexSrc = indexSrcRow + x;
                int total = 0;
                total += dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc] * k7);
            }
            for (int i = 1; i < 7; ++i) {
                indexDst = dest.startIndex + y * dest.stride + kernelRadius;
                indexSrcRow = src.startIndex + (y + i - kernelRadius) * src.stride - kernelRadius;
                k1 = kernel.data[i * 7 + 0];
                k2 = kernel.data[i * 7 + 1];
                k3 = kernel.data[i * 7 + 2];
                k4 = kernel.data[i * 7 + 3];
                k5 = kernel.data[i * 7 + 4];
                k6 = kernel.data[i * 7 + 5];
                k7 = kernel.data[i * 7 + 6];
                for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                    int indexSrc = indexSrcRow + x;
                    int total = 0;
                    total += dataSrc[indexSrc++] * k1;
                    total += dataSrc[indexSrc++] * k2;
                    total += dataSrc[indexSrc++] * k3;
                    total += dataSrc[indexSrc++] * k4;
                    total += dataSrc[indexSrc++] * k5;
                    total += dataSrc[indexSrc++] * k6;
                    int n = indexDst++;
                    dataDst[n] = (short)(dataDst[n] + (short)(total += dataSrc[indexSrc] * k7));
                }
            }
        }
    }

    public static void convolve9(Kernel2D_I32 kernel, ImageSInt16 src, ImageInt16 dest) {
        int kernelRadius;
        short[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.getRadius(); y < height - kernelRadius; ++y) {
            int k1 = kernel.data[0];
            int k2 = kernel.data[1];
            int k3 = kernel.data[2];
            int k4 = kernel.data[3];
            int k5 = kernel.data[4];
            int k6 = kernel.data[5];
            int k7 = kernel.data[6];
            int k8 = kernel.data[7];
            int k9 = kernel.data[8];
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            int indexSrcRow = src.startIndex + (y - kernelRadius) * src.stride - kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int indexSrc = indexSrcRow + x;
                int total = 0;
                total += dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                total += dataSrc[indexSrc++] * k7;
                total += dataSrc[indexSrc++] * k8;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc] * k9);
            }
            for (int i = 1; i < 9; ++i) {
                indexDst = dest.startIndex + y * dest.stride + kernelRadius;
                indexSrcRow = src.startIndex + (y + i - kernelRadius) * src.stride - kernelRadius;
                k1 = kernel.data[i * 9 + 0];
                k2 = kernel.data[i * 9 + 1];
                k3 = kernel.data[i * 9 + 2];
                k4 = kernel.data[i * 9 + 3];
                k5 = kernel.data[i * 9 + 4];
                k6 = kernel.data[i * 9 + 5];
                k7 = kernel.data[i * 9 + 6];
                k8 = kernel.data[i * 9 + 7];
                k9 = kernel.data[i * 9 + 8];
                for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                    int indexSrc = indexSrcRow + x;
                    int total = 0;
                    total += dataSrc[indexSrc++] * k1;
                    total += dataSrc[indexSrc++] * k2;
                    total += dataSrc[indexSrc++] * k3;
                    total += dataSrc[indexSrc++] * k4;
                    total += dataSrc[indexSrc++] * k5;
                    total += dataSrc[indexSrc++] * k6;
                    total += dataSrc[indexSrc++] * k7;
                    total += dataSrc[indexSrc++] * k8;
                    int n = indexDst++;
                    dataDst[n] = (short)(dataDst[n] + (short)(total += dataSrc[indexSrc] * k9));
                }
            }
        }
    }

    public static void convolve11(Kernel2D_I32 kernel, ImageSInt16 src, ImageInt16 dest) {
        int kernelRadius;
        short[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.getRadius(); y < height - kernelRadius; ++y) {
            int k1 = kernel.data[0];
            int k2 = kernel.data[1];
            int k3 = kernel.data[2];
            int k4 = kernel.data[3];
            int k5 = kernel.data[4];
            int k6 = kernel.data[5];
            int k7 = kernel.data[6];
            int k8 = kernel.data[7];
            int k9 = kernel.data[8];
            int k10 = kernel.data[9];
            int k11 = kernel.data[10];
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            int indexSrcRow = src.startIndex + (y - kernelRadius) * src.stride - kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int indexSrc = indexSrcRow + x;
                int total = 0;
                total += dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                total += dataSrc[indexSrc++] * k7;
                total += dataSrc[indexSrc++] * k8;
                total += dataSrc[indexSrc++] * k9;
                total += dataSrc[indexSrc++] * k10;
                dataDst[indexDst++] = (short)(total += dataSrc[indexSrc] * k11);
            }
            for (int i = 1; i < 11; ++i) {
                indexDst = dest.startIndex + y * dest.stride + kernelRadius;
                indexSrcRow = src.startIndex + (y + i - kernelRadius) * src.stride - kernelRadius;
                k1 = kernel.data[i * 11 + 0];
                k2 = kernel.data[i * 11 + 1];
                k3 = kernel.data[i * 11 + 2];
                k4 = kernel.data[i * 11 + 3];
                k5 = kernel.data[i * 11 + 4];
                k6 = kernel.data[i * 11 + 5];
                k7 = kernel.data[i * 11 + 6];
                k8 = kernel.data[i * 11 + 7];
                k9 = kernel.data[i * 11 + 8];
                k10 = kernel.data[i * 11 + 9];
                k11 = kernel.data[i * 11 + 10];
                for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                    int indexSrc = indexSrcRow + x;
                    int total = 0;
                    total += dataSrc[indexSrc++] * k1;
                    total += dataSrc[indexSrc++] * k2;
                    total += dataSrc[indexSrc++] * k3;
                    total += dataSrc[indexSrc++] * k4;
                    total += dataSrc[indexSrc++] * k5;
                    total += dataSrc[indexSrc++] * k6;
                    total += dataSrc[indexSrc++] * k7;
                    total += dataSrc[indexSrc++] * k8;
                    total += dataSrc[indexSrc++] * k9;
                    total += dataSrc[indexSrc++] * k10;
                    int n = indexDst++;
                    dataDst[n] = (short)(dataDst[n] + (short)(total += dataSrc[indexSrc] * k11));
                }
            }
        }
    }
}

