/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class ImplAverageDownSample2 {
    public static void down(ImageUInt8 input, ImageInt8 output) {
        int indexOut;
        int indexIn1;
        int indexIn0;
        int indexOut2;
        int y;
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        for (y = 0; y < maxY; y += 2) {
            indexOut2 = output.startIndex + y / 2 * output.stride;
            indexIn0 = input.startIndex + y * input.stride;
            indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn0++] & 0xFF;
                total += input.data[indexIn0++] & 0xFF;
                total += input.data[indexIn1++] & 0xFF;
                output.data[indexOut2++] = (byte)(((total += input.data[indexIn1++] & 0xFF) + 2) / 4);
            }
        }
        if (maxX != input.width) {
            for (y = 0; y < maxY; y += 2) {
                indexOut2 = output.startIndex + y / 2 * output.stride + output.width - 1;
                indexIn0 = input.startIndex + y * input.stride + maxX;
                indexIn1 = indexIn0 + input.stride;
                int total = input.data[indexIn0] & 0xFF;
                output.data[indexOut2] = (byte)(((total += input.data[indexIn1] & 0xFF) + 1) / 2);
            }
        }
        if (maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            int indexIn02 = input.startIndex + (input.height - 1) * input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn02++] & 0xFF;
                output.data[indexOut++] = (byte)(((total += input.data[indexIn02++] & 0xFF) + 1) / 2);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(ImageSInt8 input, ImageInt8 output) {
        int indexOut;
        int indexIn1;
        int indexIn0;
        int indexOut2;
        int y;
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        for (y = 0; y < maxY; y += 2) {
            indexOut2 = output.startIndex + y / 2 * output.stride;
            indexIn0 = input.startIndex + y * input.stride;
            indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn0++];
                total += input.data[indexIn0++];
                total += input.data[indexIn1++];
                output.data[indexOut2++] = (byte)(((total += input.data[indexIn1++]) + 2) / 4);
            }
        }
        if (maxX != input.width) {
            for (y = 0; y < maxY; y += 2) {
                indexOut2 = output.startIndex + y / 2 * output.stride + output.width - 1;
                indexIn0 = input.startIndex + y * input.stride + maxX;
                indexIn1 = indexIn0 + input.stride;
                int total = input.data[indexIn0];
                output.data[indexOut2] = (byte)(((total += input.data[indexIn1]) + 1) / 2);
            }
        }
        if (maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            int indexIn02 = input.startIndex + (input.height - 1) * input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn02++];
                output.data[indexOut++] = (byte)(((total += input.data[indexIn02++]) + 1) / 2);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(ImageUInt16 input, ImageInt16 output) {
        int indexOut;
        int indexIn1;
        int indexIn0;
        int indexOut2;
        int y;
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        for (y = 0; y < maxY; y += 2) {
            indexOut2 = output.startIndex + y / 2 * output.stride;
            indexIn0 = input.startIndex + y * input.stride;
            indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn0++] & 0xFFFF;
                total += input.data[indexIn0++] & 0xFFFF;
                total += input.data[indexIn1++] & 0xFFFF;
                output.data[indexOut2++] = (short)(((total += input.data[indexIn1++] & 0xFFFF) + 2) / 4);
            }
        }
        if (maxX != input.width) {
            for (y = 0; y < maxY; y += 2) {
                indexOut2 = output.startIndex + y / 2 * output.stride + output.width - 1;
                indexIn0 = input.startIndex + y * input.stride + maxX;
                indexIn1 = indexIn0 + input.stride;
                int total = input.data[indexIn0] & 0xFFFF;
                output.data[indexOut2] = (short)(((total += input.data[indexIn1] & 0xFFFF) + 1) / 2);
            }
        }
        if (maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            int indexIn02 = input.startIndex + (input.height - 1) * input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn02++] & 0xFFFF;
                output.data[indexOut++] = (short)(((total += input.data[indexIn02++] & 0xFFFF) + 1) / 2);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(ImageSInt16 input, ImageInt16 output) {
        int indexOut;
        int indexIn1;
        int indexIn0;
        int indexOut2;
        int y;
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        for (y = 0; y < maxY; y += 2) {
            indexOut2 = output.startIndex + y / 2 * output.stride;
            indexIn0 = input.startIndex + y * input.stride;
            indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn0++];
                total += input.data[indexIn0++];
                total += input.data[indexIn1++];
                output.data[indexOut2++] = (short)(((total += input.data[indexIn1++]) + 2) / 4);
            }
        }
        if (maxX != input.width) {
            for (y = 0; y < maxY; y += 2) {
                indexOut2 = output.startIndex + y / 2 * output.stride + output.width - 1;
                indexIn0 = input.startIndex + y * input.stride + maxX;
                indexIn1 = indexIn0 + input.stride;
                int total = input.data[indexIn0];
                output.data[indexOut2] = (short)(((total += input.data[indexIn1]) + 1) / 2);
            }
        }
        if (maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            int indexIn02 = input.startIndex + (input.height - 1) * input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn02++];
                output.data[indexOut++] = (short)(((total += input.data[indexIn02++]) + 1) / 2);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(ImageSInt32 input, ImageSInt32 output) {
        int indexOut;
        int indexIn1;
        int indexIn0;
        int indexOut2;
        int y;
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        for (y = 0; y < maxY; y += 2) {
            indexOut2 = output.startIndex + y / 2 * output.stride;
            indexIn0 = input.startIndex + y * input.stride;
            indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn0++];
                total += input.data[indexIn0++];
                total += input.data[indexIn1++];
                output.data[indexOut2++] = ((total += input.data[indexIn1++]) + 2) / 4;
            }
        }
        if (maxX != input.width) {
            for (y = 0; y < maxY; y += 2) {
                indexOut2 = output.startIndex + y / 2 * output.stride + output.width - 1;
                indexIn0 = input.startIndex + y * input.stride + maxX;
                indexIn1 = indexIn0 + input.stride;
                int total = input.data[indexIn0];
                output.data[indexOut2] = ((total += input.data[indexIn1]) + 1) / 2;
            }
        }
        if (maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            int indexIn02 = input.startIndex + (input.height - 1) * input.stride;
            for (int x = 0; x < maxX; x += 2) {
                int total = input.data[indexIn02++];
                output.data[indexOut++] = ((total += input.data[indexIn02++]) + 1) / 2;
            }
        }
        if (maxX != input.width && maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(ImageFloat32 input, ImageFloat32 output) {
        int indexOut;
        int indexIn1;
        int indexIn0;
        int indexOut2;
        int y;
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        for (y = 0; y < maxY; y += 2) {
            indexOut2 = output.startIndex + y / 2 * output.stride;
            indexIn0 = input.startIndex + y * input.stride;
            indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                float total = input.data[indexIn0++];
                total += input.data[indexIn0++];
                total += input.data[indexIn1++];
                output.data[indexOut2++] = (total += input.data[indexIn1++]) / 4.0f;
            }
        }
        if (maxX != input.width) {
            for (y = 0; y < maxY; y += 2) {
                indexOut2 = output.startIndex + y / 2 * output.stride + output.width - 1;
                indexIn0 = input.startIndex + y * input.stride + maxX;
                indexIn1 = indexIn0 + input.stride;
                float total = input.data[indexIn0];
                output.data[indexOut2] = (total += input.data[indexIn1]) / 2.0f;
            }
        }
        if (maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            int indexIn02 = input.startIndex + (input.height - 1) * input.stride;
            for (int x = 0; x < maxX; x += 2) {
                float total = input.data[indexIn02++];
                output.data[indexOut++] = (total += input.data[indexIn02++]) / 2.0f;
            }
        }
        if (maxX != input.width && maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }

    public static void down(ImageFloat64 input, ImageFloat64 output) {
        int indexOut;
        int indexIn1;
        int indexIn0;
        int indexOut2;
        int y;
        int maxY = input.height - input.height % 2;
        int maxX = input.width - input.width % 2;
        for (y = 0; y < maxY; y += 2) {
            indexOut2 = output.startIndex + y / 2 * output.stride;
            indexIn0 = input.startIndex + y * input.stride;
            indexIn1 = indexIn0 + input.stride;
            for (int x = 0; x < maxX; x += 2) {
                double total = input.data[indexIn0++];
                total += input.data[indexIn0++];
                total += input.data[indexIn1++];
                output.data[indexOut2++] = (total += input.data[indexIn1++]) / 4.0;
            }
        }
        if (maxX != input.width) {
            for (y = 0; y < maxY; y += 2) {
                indexOut2 = output.startIndex + y / 2 * output.stride + output.width - 1;
                indexIn0 = input.startIndex + y * input.stride + maxX;
                indexIn1 = indexIn0 + input.stride;
                double total = input.data[indexIn0];
                output.data[indexOut2] = (total += input.data[indexIn1]) / 2.0;
            }
        }
        if (maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            int indexIn02 = input.startIndex + (input.height - 1) * input.stride;
            for (int x = 0; x < maxX; x += 2) {
                double total = input.data[indexIn02++];
                output.data[indexOut++] = (total += input.data[indexIn02++]) / 2.0;
            }
        }
        if (maxX != input.width && maxY != input.height) {
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int indexIn = input.startIndex + (input.height - 1) * input.stride + input.width - 1;
            output.data[indexOut] = input.data[indexIn];
        }
    }
}

