/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;

public class ImplAverageResample {
    public static void horizontal(ImageUInt8 src, float srcX0, int srcY0, float srcWidth, int height, ImageFloat32 dst, int dstX0, int dstY0, int dstWidth) {
        float srcStep = srcWidth / (float)dstWidth;
        for (int y = 0; y < height; ++y) {
            int srcY = srcY0 + y;
            int dstY = dstY0 + y;
            for (int x = 0; x < dstWidth; ++x) {
                float srcStartX = srcX0 + (float)x * srcWidth / (float)dstWidth;
                float srcStopX = srcStartX + srcStep;
                int srcIntX0 = (int)srcStartX;
                int srcIntX1 = (int)srcStopX;
                float areaStart = 1.0f - srcStartX % 1.0f;
                float areaEnd = srcStopX % 1.0f;
                float total = areaStart * (float)src.unsafe_get(srcIntX0, srcY);
                ++srcIntX0;
                while (srcIntX0 < srcIntX1) {
                    total += (float)src.unsafe_get(srcIntX0, srcY);
                    ++srcIntX0;
                }
                dst.unsafe_set(dstX0 + x, dstY, (total += areaEnd * (float)src.unsafe_get(srcIntX1, srcY)) / (srcStopX - srcStartX));
            }
        }
    }

    public static void vertical(ImageFloat32 src, int srcX0, float srcY0, int width, float srcHeight, ImageUInt8 dst, int dstX0, int dstY0, int dstHeight) {
        float srcStep = srcHeight / (float)dstHeight;
        for (int x = 0; x < width; ++x) {
            int srcX = srcX0 + x;
            int dstX = dstX0 + x;
            for (int y = 0; y < dstHeight; ++y) {
                float srcStartY = srcY0 + (float)y * srcHeight / (float)dstHeight;
                float srcStopY = srcStartY + srcStep;
                int srcIntY0 = (int)srcStartY;
                int srcIntY1 = (int)srcStopY;
                float areaStart = 1.0f - srcStartY % 1.0f;
                float areaEnd = srcStopY % 1.0f;
                float total = areaStart * src.unsafe_get(srcX, srcIntY0);
                ++srcIntY0;
                while (srcIntY0 < srcIntY1) {
                    total += src.unsafe_get(srcX, srcIntY0);
                    ++srcIntY0;
                }
                dst.unsafe_set(dstX, dstY0 + y, (int)((total += areaEnd * src.unsafe_get(srcX, srcIntY1)) / (srcStopY - srcStartY) + 0.5f));
            }
        }
    }
}

