/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.BilinearPixel;
import boofcv.struct.image.ImageSInt16;

public class ImplBilinearPixel_S16
extends BilinearPixel<ImageSInt16> {
    public ImplBilinearPixel_S16() {
    }

    public ImplBilinearPixel_S16(ImageSInt16 orig) {
        this.setImage(orig);
    }

    @Override
    public float get_fast(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((ImageSInt16)this.orig).startIndex + yt * this.stride + xt;
        short[] data = ((ImageSInt16)this.orig).data;
        float val = (1.0f - ax) * (1.0f - ay) * (float)data[index];
        val += ax * (1.0f - ay) * (float)data[index + 1];
        val += ax * ay * (float)data[index + 1 + this.stride];
        return val += (1.0f - ax) * ay * (float)data[index + this.stride];
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            throw new IllegalArgumentException("Point is outside of the image");
        }
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((ImageSInt16)this.orig).startIndex + yt * this.stride + xt;
        int dx = xt == this.width - 1 ? 0 : 1;
        int dy = yt == this.height - 1 ? 0 : this.stride;
        short[] data = ((ImageSInt16)this.orig).data;
        float val = (1.0f - ax) * (1.0f - ay) * (float)data[index];
        val += ax * (1.0f - ay) * (float)data[index + dx];
        val += ax * ay * (float)data[index + dx + dy];
        return val += (1.0f - ax) * ay * (float)data[index + dy];
    }
}

