/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramid;
import java.lang.reflect.Array;

public class PyramidOps {
    public static <O extends ImageSingleBand> O[] declareOutput(ImagePyramid<?> pyramid, Class<O> outputType) {
        ImageSingleBand[] ret = (ImageSingleBand[])Array.newInstance(outputType, pyramid.getNumLayers());
        for (int i = 0; i < ret.length; ++i) {
            int w = pyramid.getWidth(i);
            int h = pyramid.getHeight(i);
            ret[i] = GeneralizedImageOps.createSingleBand(outputType, w, h);
        }
        return ret;
    }

    public static <O extends ImageSingleBand> void reshapeOutput(ImagePyramid<?> pyramid, O[] output) {
        for (int i = 0; i < output.length; ++i) {
            int w = pyramid.getWidth(i);
            int h = pyramid.getHeight(i);
            ((ImageSingleBand)output[i]).reshape(w, h);
        }
    }

    public static <I extends ImageSingleBand, O extends ImageSingleBand> void filter(ImagePyramid<I> input, FilterImageInterface<I, O> filter, O[] output) {
        for (int i = 0; i < input.getNumLayers(); ++i) {
            ImageSingleBand imageIn = (ImageSingleBand)input.getLayer(i);
            filter.process(imageIn, output[i]);
        }
    }

    public static <I extends ImageSingleBand, O extends ImageSingleBand> void gradient(ImagePyramid<I> input, ImageGradient<I, O> gradient, O[] derivX, O[] derivY) {
        for (int i = 0; i < input.getNumLayers(); ++i) {
            ImageSingleBand imageIn = (ImageSingleBand)input.getLayer(i);
            gradient.process(imageIn, derivX[i], derivY[i]);
        }
    }
}

