/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.core.image.ConvertImage;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;
import java.lang.reflect.Method;

public class GConvertImage {
    public static void convert(ImageSingleBand input, ImageSingleBand output) {
        if (input.getClass() == output.getClass()) {
            output.setTo(input);
        } else {
            try {
                Method m = ConvertImage.class.getMethod("convert", input.getClass(), output.getClass());
                m.invoke(null, input, output);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unknown conversion");
            }
        }
    }

    public static <T extends ImageSingleBand> T average(MultiSpectral<T> input, T output) {
        Class<T> type = input.getType();
        if (type == ImageUInt8.class) {
            return (T)ConvertImage.average(input, (ImageUInt8)output);
        }
        if (type == ImageSInt8.class) {
            return (T)ConvertImage.average(input, (ImageSInt8)output);
        }
        if (type == ImageUInt16.class) {
            return (T)ConvertImage.average(input, (ImageUInt16)output);
        }
        if (type == ImageSInt16.class) {
            return (T)ConvertImage.average(input, (ImageSInt16)output);
        }
        if (type == ImageSInt32.class) {
            return (T)ConvertImage.average(input, (ImageSInt32)output);
        }
        if (type == ImageSInt64.class) {
            return (T)ConvertImage.average(input, (ImageSInt64)output);
        }
        if (type == ImageFloat32.class) {
            return (T)ConvertImage.average(input, (ImageFloat32)output);
        }
        if (type == ImageFloat64.class) {
            return (T)ConvertImage.average(input, (ImageFloat64)output);
        }
        throw new IllegalArgumentException("Unknown image type: " + type.getSimpleName());
    }
}

