/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.interpolate;

import boofcv.abst.filter.interpolate.InterpolatePixel_S_to_MB_MultiSpectral;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.interpolate.impl.BilinearRectangle_F32;
import boofcv.alg.interpolate.impl.BilinearRectangle_S16;
import boofcv.alg.interpolate.impl.BilinearRectangle_U8;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_F32;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_F64;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_S16;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_S32;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_U8;
import boofcv.alg.interpolate.impl.ImplInterpolatePixelConvolution_F32;
import boofcv.alg.interpolate.impl.ImplInterpolatePixelConvolution_S16;
import boofcv.alg.interpolate.impl.ImplInterpolatePixelConvolution_U8;
import boofcv.alg.interpolate.impl.ImplPolynomialPixel_F32;
import boofcv.alg.interpolate.impl.ImplPolynomialPixel_I;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_F32;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_S16;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_S32;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_U16;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_U8;
import boofcv.alg.interpolate.impl.NearestNeighborRectangle_F32;
import boofcv.alg.interpolate.kernel.BicubicKernel_F32;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class FactoryInterpolation {
    public static <T extends ImageSingleBand> InterpolatePixelS<T> createPixelS(double min, double max, TypeInterpolate type, ImageDataType dataType) {
        Class t = ImageDataType.typeToClass(dataType);
        return FactoryInterpolation.createPixelS(min, max, type, t);
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> createPixelS(double min, double max, TypeInterpolate type, Class<T> imageType) {
        switch (type) {
            case NEAREST_NEIGHBOR: {
                return FactoryInterpolation.nearestNeighborPixelS(imageType);
            }
            case BILINEAR: {
                return FactoryInterpolation.bilinearPixelS(imageType);
            }
            case BICUBIC: {
                return FactoryInterpolation.bicubicS(0.5f, (float)min, (float)max, imageType);
            }
            case POLYNOMIAL4: {
                return FactoryInterpolation.polynomialS(4, min, max, imageType);
            }
        }
        throw new IllegalArgumentException("Add type: " + (Object)((Object)type));
    }

    public static <T extends ImageMultiBand> InterpolatePixelMB<T> createPixelMB(double min, double max, TypeInterpolate type, ImageType<T> imageType) {
        switch (imageType.getFamily()) {
            case MULTI_SPECTRAL: {
                return FactoryInterpolation.createPixelMB(FactoryInterpolation.createPixelS(min, max, type, imageType.getDataType()));
            }
            case SINGLE_BAND: {
                throw new IllegalArgumentException("Need to specify a multi-band image type");
            }
            case INTERLEAVED: {
                throw new IllegalArgumentException("Not yet supported.  Post a message letting us know you need this.  Use MultiSpectral instead for now.");
            }
        }
        throw new IllegalArgumentException("Add type: " + (Object)((Object)type));
    }

    public static <T extends ImageSingleBand> InterpolatePixelMB<MultiSpectral<T>> createPixelMB(InterpolatePixelS<T> singleBand) {
        return new InterpolatePixel_S_to_MB_MultiSpectral<T>(singleBand);
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> bilinearPixelS(T image) {
        InterpolatePixelS<?> ret = FactoryInterpolation.bilinearPixelS(image.getClass());
        ret.setImage(image);
        return ret;
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> bilinearPixelS(Class<T> type) {
        if (type == ImageFloat32.class) {
            return new ImplBilinearPixel_F32();
        }
        if (type == ImageFloat64.class) {
            return new ImplBilinearPixel_F64();
        }
        if (type == ImageUInt8.class) {
            return new ImplBilinearPixel_U8();
        }
        if (type == ImageSInt16.class) {
            return new ImplBilinearPixel_S16();
        }
        if (type == ImageSInt32.class) {
            return new ImplBilinearPixel_S32();
        }
        throw new RuntimeException("Unknown image type: " + type.getName());
    }

    public static <T extends ImageSingleBand> InterpolateRectangle<T> bilinearRectangle(T image) {
        InterpolateRectangle<?> ret = FactoryInterpolation.bilinearRectangle(image.getClass());
        ret.setImage(image);
        return ret;
    }

    public static <T extends ImageSingleBand> InterpolateRectangle<T> bilinearRectangle(Class<T> type) {
        if (type == ImageFloat32.class) {
            return new BilinearRectangle_F32();
        }
        if (type == ImageUInt8.class) {
            return new BilinearRectangle_U8();
        }
        if (type == ImageSInt16.class) {
            return new BilinearRectangle_S16();
        }
        throw new RuntimeException("Unknown image type: " + type.getName());
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> nearestNeighborPixelS(Class<T> type) {
        if (type == ImageFloat32.class) {
            return new NearestNeighborPixel_F32();
        }
        if (type == ImageUInt8.class) {
            return new NearestNeighborPixel_U8();
        }
        if (type == ImageSInt16.class) {
            return new NearestNeighborPixel_S16();
        }
        if (type == ImageUInt16.class) {
            return new NearestNeighborPixel_U16();
        }
        if (type == ImageSInt32.class) {
            return new NearestNeighborPixel_S32();
        }
        throw new RuntimeException("Unknown image type: " + type.getName());
    }

    public static <T extends ImageSingleBand> InterpolateRectangle<T> nearestNeighborRectangle(Class<?> type) {
        if (type == ImageFloat32.class) {
            return new NearestNeighborRectangle_F32();
        }
        throw new RuntimeException("Unknown image type: " + type.getName());
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> bicubicS(float param, float min, float max, Class<T> type) {
        BicubicKernel_F32 kernel = new BicubicKernel_F32(param);
        if (type == ImageFloat32.class) {
            return new ImplInterpolatePixelConvolution_F32(kernel, min, max);
        }
        if (type == ImageUInt8.class) {
            return new ImplInterpolatePixelConvolution_U8(kernel, min, max);
        }
        if (type == ImageSInt16.class) {
            return new ImplInterpolatePixelConvolution_S16(kernel, min, max);
        }
        throw new RuntimeException("Unknown image type: " + type.getName());
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> polynomialS(int maxDegree, double min, double max, Class<T> type) {
        if (type == ImageFloat32.class) {
            return new ImplPolynomialPixel_F32(maxDegree, (float)min, (float)max);
        }
        if (ImageInteger.class.isAssignableFrom(type)) {
            return new ImplPolynomialPixel_I(maxDegree, (float)min, (float)max);
        }
        throw new RuntimeException("Unknown image type: " + type.getName());
    }
}

