/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

import boofcv.struct.convolve.Kernel2D;

public class Kernel2D_F64
extends Kernel2D {
    public double[] data;

    public Kernel2D_F64(int width, double ... data) {
        if (width % 2 == 0 && width <= 0) {
            throw new IllegalArgumentException("invalid width");
        }
        this.width = width;
        this.data = new double[width * width];
        System.arraycopy(data, 0, this.data, 0, this.data.length);
    }

    public Kernel2D_F64(int width) {
        if (width % 2 == 0 && width <= 0) {
            throw new IllegalArgumentException("invalid width");
        }
        this.data = new double[width * width];
        this.width = width;
    }

    protected Kernel2D_F64() {
    }

    public static Kernel2D_F64 wrap(double[] data, int width) {
        if (width % 2 == 0 && width <= 0 && width * width > data.length) {
            throw new IllegalArgumentException("invalid width");
        }
        Kernel2D_F64 ret = new Kernel2D_F64();
        ret.data = data;
        ret.width = width;
        return ret;
    }

    public double get(int x, int y) {
        return this.data[y * this.width + x];
    }

    public void set(int x, int y, double value) {
        this.data[y * this.width + x] = value;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    public double[] getData() {
        return this.data;
    }

    public void print() {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                System.out.printf("%5.2f ", this.data[i * this.width + j]);
            }
            System.out.println();
        }
        System.out.println();
    }
}

