/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageFloat;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public enum ImageDataType {
    U8(false, Byte.TYPE),
    S8(true, Byte.TYPE),
    U16(false, Short.TYPE),
    S16(true, Short.TYPE),
    S32(true, Integer.TYPE),
    S64(true, Long.TYPE),
    F32(true, Float.TYPE),
    F64(true, Double.TYPE),
    I8(Byte.TYPE),
    I16(Short.TYPE),
    I(true),
    F(true);

    private int numBits;
    private boolean isAbstract;
    private boolean isSigned;
    private boolean isInteger;
    private double maxValue;
    private double minValue;
    private Class dataType;
    private Class sumType;

    public static ImageDataType classToType(Class imageClass) {
        if (imageClass == ImageUInt8.class) {
            return U8;
        }
        if (imageClass == ImageSInt8.class) {
            return S8;
        }
        if (imageClass == ImageUInt16.class) {
            return U16;
        }
        if (imageClass == ImageSInt16.class) {
            return S16;
        }
        if (imageClass == ImageSInt32.class) {
            return S32;
        }
        if (imageClass == ImageSInt64.class) {
            return S64;
        }
        if (imageClass == ImageFloat32.class) {
            return F32;
        }
        if (imageClass == ImageFloat64.class) {
            return F64;
        }
        if (imageClass == ImageInt8.class) {
            return I8;
        }
        if (imageClass == ImageInt16.class) {
            return I16;
        }
        if (imageClass == ImageInteger.class) {
            return I;
        }
        if (imageClass == ImageFloat.class) {
            return F;
        }
        throw new RuntimeException("Add");
    }

    public static Class typeToClass(ImageDataType type) {
        switch (type) {
            case U8: {
                return ImageUInt8.class;
            }
            case S8: {
                return ImageSInt8.class;
            }
            case U16: {
                return ImageUInt16.class;
            }
            case S16: {
                return ImageSInt16.class;
            }
            case S32: {
                return ImageSInt32.class;
            }
            case S64: {
                return ImageSInt64.class;
            }
            case F32: {
                return ImageFloat32.class;
            }
            case F64: {
                return ImageFloat64.class;
            }
            case I8: {
                return ImageInt8.class;
            }
            case I16: {
                return ImageInt16.class;
            }
            case I: {
                return ImageInteger.class;
            }
            case F: {
                return ImageFloat.class;
            }
        }
        throw new RuntimeException("Add");
    }

    private ImageDataType(boolean isInteger) {
        this.isAbstract = true;
        this.isInteger = isInteger;
    }

    private ImageDataType(Class dataType) {
        this.isAbstract = true;
        this.dataType = dataType;
        this.configureByDataType(dataType);
    }

    private ImageDataType(boolean isSigned, Class<?> dataType) {
        this.isAbstract = false;
        this.isSigned = isSigned;
        this.dataType = dataType;
        this.configureByDataType(dataType);
    }

    private void configureByDataType(Class<?> dataType) {
        if (dataType == Float.TYPE || dataType == Double.TYPE) {
            this.sumType = dataType;
            this.isInteger = false;
            this.numBits = dataType == Float.TYPE ? 32 : 64;
        } else {
            this.isInteger = true;
            if (dataType == Byte.TYPE) {
                this.numBits = 8;
            } else if (dataType == Short.TYPE) {
                this.numBits = 16;
            } else if (dataType == Integer.TYPE) {
                this.numBits = 32;
            } else if (dataType == Long.TYPE) {
                this.numBits = 64;
            }
            this.sumType = this.numBits <= 32 ? Integer.TYPE : Long.TYPE;
        }
        this.configureMinMaxValues();
    }

    private void configureMinMaxValues() {
        if (this.isInteger) {
            switch (this.numBits) {
                case 8: {
                    this.minValue = -128.0;
                    this.maxValue = 127.0;
                    break;
                }
                case 16: {
                    this.minValue = -32768.0;
                    this.maxValue = 32767.0;
                    break;
                }
                case 32: {
                    this.minValue = -2.147483648E9;
                    this.maxValue = 2.147483647E9;
                    break;
                }
                case 64: {
                    this.minValue = -9.223372036854776E18;
                    this.maxValue = 9.223372036854776E18;
                }
            }
        } else {
            switch (this.numBits) {
                case 32: {
                    this.minValue = 1.4E-45f;
                    this.maxValue = 3.4028234663852886E38;
                    break;
                }
                case 64: {
                    this.minValue = Double.MIN_VALUE;
                    this.maxValue = Double.MAX_VALUE;
                }
            }
        }
        if (!this.isSigned) {
            this.maxValue += -this.minValue;
            this.minValue = 0.0;
        }
    }

    public int getNumBits() {
        return this.numBits;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public Class getDataType() {
        return this.dataType;
    }

    public Class getSumType() {
        return this.sumType;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.maxValue;
    }
}

