/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageFloat;

public class ImageFloat32
extends ImageFloat<ImageFloat32> {
    public float[] data;

    public ImageFloat32(int width, int height) {
        super(width, height);
    }

    public ImageFloat32() {
    }

    public float get(int x, int y) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds: ( " + x + " , " + y + " )");
        }
        return this.unsafe_get(x, y);
    }

    public float unsafe_get(int x, int y) {
        return this.data[this.getIndex(x, y)];
    }

    public void set(int x, int y, float value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds: " + x + " " + y);
        }
        this.unsafe_set(x, y, value);
    }

    public void unsafe_set(int x, int y, float value) {
        this.data[this.getIndex((int)x, (int)y)] = value;
    }

    public void print() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                System.out.printf("%4.1f ", Float.valueOf(this.unsafe_get(x, y)));
            }
            System.out.println();
        }
    }

    public void print(String format) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                System.out.printf(format + " ", Float.valueOf(this.unsafe_get(x, y)));
            }
            System.out.println();
        }
    }

    public void printInt() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                System.out.printf("%3d ", (int)this.unsafe_get(x, y));
            }
            System.out.println();
        }
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (float[])data;
    }

    @Override
    public ImageFloat32 _createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new ImageFloat32();
        }
        return new ImageFloat32(imgWidth, imgHeight);
    }

    @Override
    public ImageDataType getTypeInfo() {
        return ImageDataType.F32;
    }
}

