/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageInteger;

public abstract class ImageInt16<T extends ImageInt16>
extends ImageInteger<T> {
    public short[] data;

    protected ImageInt16(int width, int height) {
        super(width, height);
    }

    protected ImageInt16() {
    }

    @Override
    public void set(int x, int y, int value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        this.data[this.getIndex((int)x, (int)y)] = (short)value;
    }

    @Override
    public void unsafe_set(int x, int y, int value) {
        this.data[this.getIndex((int)x, (int)y)] = (short)value;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (short[])data;
    }

    @Override
    public ImageDataType getTypeInfo() {
        return ImageDataType.I16;
    }
}

