/*
 * Copyright (c) 2011-2013, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.core.image;

import boofcv.alg.InputSanityCheck;
import boofcv.core.image.impl.ImplConvertImage;
import boofcv.core.image.impl.ImplConvertMsToSingle;
import boofcv.struct.image.*;

/**
 * <p>
 * Functions for converting between different image types. Pixel values are converted by typecasting.
 * When converting between signed and unsigned types, care should be taken to avoid numerical overflow.
 * </p>
 *
 * <p>
 * DO NOT MODIFY: This class was automatically generated by {@link boofcv.core.image.GenerateConvertImage}
 * </p>
 *
 * @author Peter Abeles
 */
public class ConvertImage {

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt8} into a {@link boofcv.struct.image.ImageSInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt8 convert(ImageUInt8 input, ImageSInt8 output) {
		if (output == null) {
			output = new ImageSInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt8} into a {@link boofcv.struct.image.ImageUInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt16 convert(ImageUInt8 input, ImageUInt16 output) {
		if (output == null) {
			output = new ImageUInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt8} into a {@link boofcv.struct.image.ImageSInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt16 convert(ImageUInt8 input, ImageSInt16 output) {
		if (output == null) {
			output = new ImageSInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt8} into a {@link boofcv.struct.image.ImageSInt32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt32 convert(ImageUInt8 input, ImageSInt32 output) {
		if (output == null) {
			output = new ImageSInt32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt8} into a {@link boofcv.struct.image.ImageSInt64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt64 convert(ImageUInt8 input, ImageSInt64 output) {
		if (output == null) {
			output = new ImageSInt64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt8} into a {@link boofcv.struct.image.ImageFloat32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat32 convert(ImageUInt8 input, ImageFloat32 output) {
		if (output == null) {
			output = new ImageFloat32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt8} into a {@link boofcv.struct.image.ImageFloat64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat64 convert(ImageUInt8 input, ImageFloat64 output) {
		if (output == null) {
			output = new ImageFloat64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * Converts a {@link MultiSpectral} into a {@link ImageSingleBand} by computing the average value of each pixel
	 * across all the bands.
	 * 
	 * @param input Input MultiSpectral image that is being converted. Not modified.
	 * @param output (Optional) The single band output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt8 average( MultiSpectral<ImageUInt8> input , ImageUInt8 output ) {
		if (output == null) {
			output = new ImageUInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertMsToSingle.average(input, output);

		return output;
	}
	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt8} into a {@link boofcv.struct.image.ImageUInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt8 convert(ImageSInt8 input, ImageUInt8 output) {
		if (output == null) {
			output = new ImageUInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt8} into a {@link boofcv.struct.image.ImageUInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt16 convert(ImageSInt8 input, ImageUInt16 output) {
		if (output == null) {
			output = new ImageUInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt8} into a {@link boofcv.struct.image.ImageSInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt16 convert(ImageSInt8 input, ImageSInt16 output) {
		if (output == null) {
			output = new ImageSInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt8} into a {@link boofcv.struct.image.ImageSInt32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt32 convert(ImageSInt8 input, ImageSInt32 output) {
		if (output == null) {
			output = new ImageSInt32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt8} into a {@link boofcv.struct.image.ImageSInt64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt64 convert(ImageSInt8 input, ImageSInt64 output) {
		if (output == null) {
			output = new ImageSInt64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt8} into a {@link boofcv.struct.image.ImageFloat32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat32 convert(ImageSInt8 input, ImageFloat32 output) {
		if (output == null) {
			output = new ImageFloat32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt8} into a {@link boofcv.struct.image.ImageFloat64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat64 convert(ImageSInt8 input, ImageFloat64 output) {
		if (output == null) {
			output = new ImageFloat64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * Converts a {@link MultiSpectral} into a {@link ImageSingleBand} by computing the average value of each pixel
	 * across all the bands.
	 * 
	 * @param input Input MultiSpectral image that is being converted. Not modified.
	 * @param output (Optional) The single band output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt8 average( MultiSpectral<ImageSInt8> input , ImageSInt8 output ) {
		if (output == null) {
			output = new ImageSInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertMsToSingle.average(input, output);

		return output;
	}
	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt16} into a {@link boofcv.struct.image.ImageUInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt8 convert(ImageUInt16 input, ImageUInt8 output) {
		if (output == null) {
			output = new ImageUInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt16} into a {@link boofcv.struct.image.ImageSInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt8 convert(ImageUInt16 input, ImageSInt8 output) {
		if (output == null) {
			output = new ImageSInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt16} into a {@link boofcv.struct.image.ImageSInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt16 convert(ImageUInt16 input, ImageSInt16 output) {
		if (output == null) {
			output = new ImageSInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt16} into a {@link boofcv.struct.image.ImageSInt32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt32 convert(ImageUInt16 input, ImageSInt32 output) {
		if (output == null) {
			output = new ImageSInt32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt16} into a {@link boofcv.struct.image.ImageSInt64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt64 convert(ImageUInt16 input, ImageSInt64 output) {
		if (output == null) {
			output = new ImageSInt64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt16} into a {@link boofcv.struct.image.ImageFloat32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat32 convert(ImageUInt16 input, ImageFloat32 output) {
		if (output == null) {
			output = new ImageFloat32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageUInt16} into a {@link boofcv.struct.image.ImageFloat64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat64 convert(ImageUInt16 input, ImageFloat64 output) {
		if (output == null) {
			output = new ImageFloat64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * Converts a {@link MultiSpectral} into a {@link ImageSingleBand} by computing the average value of each pixel
	 * across all the bands.
	 * 
	 * @param input Input MultiSpectral image that is being converted. Not modified.
	 * @param output (Optional) The single band output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt16 average( MultiSpectral<ImageUInt16> input , ImageUInt16 output ) {
		if (output == null) {
			output = new ImageUInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertMsToSingle.average(input, output);

		return output;
	}
	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt16} into a {@link boofcv.struct.image.ImageUInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt8 convert(ImageSInt16 input, ImageUInt8 output) {
		if (output == null) {
			output = new ImageUInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt16} into a {@link boofcv.struct.image.ImageSInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt8 convert(ImageSInt16 input, ImageSInt8 output) {
		if (output == null) {
			output = new ImageSInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt16} into a {@link boofcv.struct.image.ImageUInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt16 convert(ImageSInt16 input, ImageUInt16 output) {
		if (output == null) {
			output = new ImageUInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt16} into a {@link boofcv.struct.image.ImageSInt32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt32 convert(ImageSInt16 input, ImageSInt32 output) {
		if (output == null) {
			output = new ImageSInt32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt16} into a {@link boofcv.struct.image.ImageSInt64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt64 convert(ImageSInt16 input, ImageSInt64 output) {
		if (output == null) {
			output = new ImageSInt64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt16} into a {@link boofcv.struct.image.ImageFloat32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat32 convert(ImageSInt16 input, ImageFloat32 output) {
		if (output == null) {
			output = new ImageFloat32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt16} into a {@link boofcv.struct.image.ImageFloat64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat64 convert(ImageSInt16 input, ImageFloat64 output) {
		if (output == null) {
			output = new ImageFloat64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * Converts a {@link MultiSpectral} into a {@link ImageSingleBand} by computing the average value of each pixel
	 * across all the bands.
	 * 
	 * @param input Input MultiSpectral image that is being converted. Not modified.
	 * @param output (Optional) The single band output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt16 average( MultiSpectral<ImageSInt16> input , ImageSInt16 output ) {
		if (output == null) {
			output = new ImageSInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertMsToSingle.average(input, output);

		return output;
	}
	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt32} into a {@link boofcv.struct.image.ImageUInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt8 convert(ImageSInt32 input, ImageUInt8 output) {
		if (output == null) {
			output = new ImageUInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt32} into a {@link boofcv.struct.image.ImageSInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt8 convert(ImageSInt32 input, ImageSInt8 output) {
		if (output == null) {
			output = new ImageSInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt32} into a {@link boofcv.struct.image.ImageUInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt16 convert(ImageSInt32 input, ImageUInt16 output) {
		if (output == null) {
			output = new ImageUInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt32} into a {@link boofcv.struct.image.ImageSInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt16 convert(ImageSInt32 input, ImageSInt16 output) {
		if (output == null) {
			output = new ImageSInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt32} into a {@link boofcv.struct.image.ImageSInt64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt64 convert(ImageSInt32 input, ImageSInt64 output) {
		if (output == null) {
			output = new ImageSInt64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt32} into a {@link boofcv.struct.image.ImageFloat32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat32 convert(ImageSInt32 input, ImageFloat32 output) {
		if (output == null) {
			output = new ImageFloat32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt32} into a {@link boofcv.struct.image.ImageFloat64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat64 convert(ImageSInt32 input, ImageFloat64 output) {
		if (output == null) {
			output = new ImageFloat64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * Converts a {@link MultiSpectral} into a {@link ImageSingleBand} by computing the average value of each pixel
	 * across all the bands.
	 * 
	 * @param input Input MultiSpectral image that is being converted. Not modified.
	 * @param output (Optional) The single band output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt32 average( MultiSpectral<ImageSInt32> input , ImageSInt32 output ) {
		if (output == null) {
			output = new ImageSInt32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertMsToSingle.average(input, output);

		return output;
	}
	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt64} into a {@link boofcv.struct.image.ImageUInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt8 convert(ImageSInt64 input, ImageUInt8 output) {
		if (output == null) {
			output = new ImageUInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt64} into a {@link boofcv.struct.image.ImageSInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt8 convert(ImageSInt64 input, ImageSInt8 output) {
		if (output == null) {
			output = new ImageSInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt64} into a {@link boofcv.struct.image.ImageUInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt16 convert(ImageSInt64 input, ImageUInt16 output) {
		if (output == null) {
			output = new ImageUInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt64} into a {@link boofcv.struct.image.ImageSInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt16 convert(ImageSInt64 input, ImageSInt16 output) {
		if (output == null) {
			output = new ImageSInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt64} into a {@link boofcv.struct.image.ImageSInt32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt32 convert(ImageSInt64 input, ImageSInt32 output) {
		if (output == null) {
			output = new ImageSInt32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt64} into a {@link boofcv.struct.image.ImageFloat32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat32 convert(ImageSInt64 input, ImageFloat32 output) {
		if (output == null) {
			output = new ImageFloat32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageSInt64} into a {@link boofcv.struct.image.ImageFloat64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat64 convert(ImageSInt64 input, ImageFloat64 output) {
		if (output == null) {
			output = new ImageFloat64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * Converts a {@link MultiSpectral} into a {@link ImageSingleBand} by computing the average value of each pixel
	 * across all the bands.
	 * 
	 * @param input Input MultiSpectral image that is being converted. Not modified.
	 * @param output (Optional) The single band output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt64 average( MultiSpectral<ImageSInt64> input , ImageSInt64 output ) {
		if (output == null) {
			output = new ImageSInt64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertMsToSingle.average(input, output);

		return output;
	}
	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat32} into a {@link boofcv.struct.image.ImageUInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt8 convert(ImageFloat32 input, ImageUInt8 output) {
		if (output == null) {
			output = new ImageUInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat32} into a {@link boofcv.struct.image.ImageSInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt8 convert(ImageFloat32 input, ImageSInt8 output) {
		if (output == null) {
			output = new ImageSInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat32} into a {@link boofcv.struct.image.ImageUInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt16 convert(ImageFloat32 input, ImageUInt16 output) {
		if (output == null) {
			output = new ImageUInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat32} into a {@link boofcv.struct.image.ImageSInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt16 convert(ImageFloat32 input, ImageSInt16 output) {
		if (output == null) {
			output = new ImageSInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat32} into a {@link boofcv.struct.image.ImageSInt32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt32 convert(ImageFloat32 input, ImageSInt32 output) {
		if (output == null) {
			output = new ImageSInt32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat32} into a {@link boofcv.struct.image.ImageSInt64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt64 convert(ImageFloat32 input, ImageSInt64 output) {
		if (output == null) {
			output = new ImageSInt64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat32} into a {@link boofcv.struct.image.ImageFloat64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat64 convert(ImageFloat32 input, ImageFloat64 output) {
		if (output == null) {
			output = new ImageFloat64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * Converts a {@link MultiSpectral} into a {@link ImageSingleBand} by computing the average value of each pixel
	 * across all the bands.
	 * 
	 * @param input Input MultiSpectral image that is being converted. Not modified.
	 * @param output (Optional) The single band output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat32 average( MultiSpectral<ImageFloat32> input , ImageFloat32 output ) {
		if (output == null) {
			output = new ImageFloat32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertMsToSingle.average(input, output);

		return output;
	}
	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat64} into a {@link boofcv.struct.image.ImageUInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt8 convert(ImageFloat64 input, ImageUInt8 output) {
		if (output == null) {
			output = new ImageUInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat64} into a {@link boofcv.struct.image.ImageSInt8}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt8 convert(ImageFloat64 input, ImageSInt8 output) {
		if (output == null) {
			output = new ImageSInt8(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat64} into a {@link boofcv.struct.image.ImageUInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageUInt16 convert(ImageFloat64 input, ImageUInt16 output) {
		if (output == null) {
			output = new ImageUInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat64} into a {@link boofcv.struct.image.ImageSInt16}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt16 convert(ImageFloat64 input, ImageSInt16 output) {
		if (output == null) {
			output = new ImageSInt16(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat64} into a {@link boofcv.struct.image.ImageSInt32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt32 convert(ImageFloat64 input, ImageSInt32 output) {
		if (output == null) {
			output = new ImageSInt32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat64} into a {@link boofcv.struct.image.ImageSInt64}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageSInt64 convert(ImageFloat64 input, ImageSInt64 output) {
		if (output == null) {
			output = new ImageSInt64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * <p>
	 * Converts an {@link boofcv.struct.image.ImageFloat64} into a {@link boofcv.struct.image.ImageFloat32}.
	 * </p>
	 *
	 * @param input Input image which is being converted. Not modified.
	 * @param output (Optional) The output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat32 convert(ImageFloat64 input, ImageFloat32 output) {
		if (output == null) {
			output = new ImageFloat32(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertImage.convert(input, output);

		return output;
	}

	/**
	 * Converts a {@link MultiSpectral} into a {@link ImageSingleBand} by computing the average value of each pixel
	 * across all the bands.
	 * 
	 * @param input Input MultiSpectral image that is being converted. Not modified.
	 * @param output (Optional) The single band output image.  If null a new image is created. Modified.
	 * @return Converted image.
	 */
	public static ImageFloat64 average( MultiSpectral<ImageFloat64> input , ImageFloat64 output ) {
		if (output == null) {
			output = new ImageFloat64(input.width, input.height);
		} else {
			InputSanityCheck.checkSameShape(input, output);
		}

		ImplConvertMsToSingle.average(input, output);

		return output;
	}

}
