/*
 * Copyright (c) 2011-2014, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.struct.convolve;

/**
 * Floating point 1D convolution kernel that extends {@link Kernel1D}.
 *
 * <p>
 * WARNING: Do not modify.  Automatically generated by {@link boofcv.struct.convolve.GenerateKernel1D}.
 * </p>
 *
 * @author Peter Abeles
 */
public class Kernel1D_I32 extends Kernel1D {

	public int data[];

	/**
	 * Creates a new kernel whose initial values are specified by data and width.  The length
	 * of its internal data will be width.  Data must be at least as long as width.
	 *
	 * @param data  The value of the kernel. Not modified.  Reference is not saved.
	 * @param width The kernels width.  Must be odd.
	 */
	public Kernel1D_I32(int data[], int width) {
		this(data,width/2,width);
		if( width % 2 != 1 )
			throw new IllegalArgumentException("Kernel must be add to use this constructor");
	}

	/**
	 * Creates a new kernel whose initial values are specified by data and width.  The length
	 * of its internal data will be width.  Data must be at least as long as width.
	 *
	 * @param data  The value of the kernel. Not modified.  Reference is not saved.
	 * @param width The kernels width.  Must be odd.
	 * @param offset Location of the origin in the array
	 */
	public Kernel1D_I32(int data[], int offset , int width) {
		super(offset,width);

		this.data = new int[width];
		System.arraycopy(data, 0, this.data, 0, width);
	}

	/**
	 * Create a kernel whose elements are all equal to zero.
	 *
	 * @param width How wide the kernel is.  Must be odd.
	 */
	public Kernel1D_I32(int width) {
		this(width/2,width);
	}

	/**
	 * Create a kernel whose elements are all equal to zero.
	 *
	 * @param width How wide the kernel is.  Must be odd.
	 * @param offset Location of the origin in the array
	 */
	public Kernel1D_I32(int offset , int width) {
		super(offset,width);
		data = new int[width];
	}

	protected Kernel1D_I32() {
	}

	/**
	 * Creates a kernel whose elements are the specified data array and has
	 * the specified width.
	 *
	 * @param data  The array who will be the kernel's data.  Reference is saved.
	 * @param width The kernel's width.
	 * @return A new kernel.
	 */
	public static Kernel1D_I32 wrap(int data[], int width) {
		Kernel1D_I32 ret = new Kernel1D_I32();
		ret.data = data;
		ret.width = width;
		ret.offset = width/2;

		return ret;
	}

	@Override
	public boolean isInteger() {
		return true;
	}

	public int get(int i) {
		return data[i];
	}

	public int computeSum() {
		int sum = 0;
		for( int i = 0; i < data.length; i++ ) {
			sum += data[i];
		}

		return sum;
	}

	public int[] getData() {
		return data;
	}

	public void print() {
		for (int i = 0; i < width; i++) {
			System.out.printf("%6d ", data[i]);
		}
		System.out.println();
	}
}

