/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.derivative.DerivativeHelperFunctions;
import boofcv.alg.filter.derivative.impl.GradientTwo_Standard;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class GradientTwo {
    public static Kernel1D_I32 kernelDeriv_I32 = new Kernel1D_I32(new int[]{-1, 1}, 0, 2);
    public static Kernel1D_F32 kernelDeriv_F32 = new Kernel1D_F32(new float[]{-1.0f, 1.0f}, 0, 2);

    public static Kernel1D getKernelX(boolean isInteger) {
        if (isInteger) {
            return kernelDeriv_I32;
        }
        return kernelDeriv_F32;
    }

    public static void process(ImageUInt8 orig, ImageSInt16 derivX, ImageSInt16 derivY, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(orig, derivX, derivY);
        GradientTwo_Standard.process(orig, derivX, derivY);
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivX, kernelDeriv_I32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivY, kernelDeriv_I32, border);
        }
    }

    public static void process(ImageSInt16 orig, ImageSInt16 derivX, ImageSInt16 derivY, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(orig, derivX, derivY);
        GradientTwo_Standard.process(orig, derivX, derivY);
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivX, kernelDeriv_I32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivY, kernelDeriv_I32, border);
        }
    }

    public static void process(ImageFloat32 orig, ImageFloat32 derivX, ImageFloat32 derivY, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(orig, derivX, derivY);
        GradientTwo_Standard.process(orig, derivX, derivY);
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivX, kernelDeriv_F32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivY, kernelDeriv_F32, border);
        }
    }
}

