/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.alg.InputSanityCheck;
import boofcv.core.image.impl.ImplConvertImage;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageFloat;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;
import boofcv.testing.BoofTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GeneralizedImageOps {
    public static <T extends ImageSingleBand> T convert(ImageSingleBand<?> src, T dst, Class<T> typeDst) {
        if (dst == null) {
            dst = GeneralizedImageOps.createSingleBand(typeDst, src.width, src.height);
        } else {
            InputSanityCheck.checkSameShape(src, dst);
        }
        GeneralizedImageOps.convert(src, dst);
        return dst;
    }

    public static void convert(ImageSingleBand<?> src, ImageSingleBand<?> dst) {
        if (src.getClass() == dst.getClass()) {
            dst.setTo(src);
            return;
        }
        Method m = BoofTesting.findMethod(ImplConvertImage.class, "convert", src.getClass(), dst.getClass());
        try {
            m.invoke(null, src, dst);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isFloatingPoint(Class<?> imgType) {
        return ImageFloat.class.isAssignableFrom(imgType);
    }

    public static double get(ImageSingleBand img, int x, int y) {
        if (img instanceof ImageInt8) {
            return ((ImageInt8)img).get(x, y);
        }
        if (img instanceof ImageInt16) {
            return ((ImageInt16)img).get(x, y);
        }
        if (img instanceof ImageSInt32) {
            return ((ImageSInt32)img).get(x, y);
        }
        if (img instanceof ImageFloat32) {
            return ((ImageFloat32)img).get(x, y);
        }
        if (img instanceof ImageFloat64) {
            return ((ImageFloat64)img).get(x, y);
        }
        if (img instanceof ImageSInt64) {
            return ((ImageSInt64)img).get(x, y);
        }
        throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
    }

    public static double get(ImageBase img, int x, int y, int band) {
        if (img instanceof ImageSingleBand) {
            return GeneralizedImageOps.get((ImageSingleBand)img, x, y);
        }
        if (img instanceof ImageInterleaved) {
            return GeneralizedImageOps.get((ImageInterleaved)img, x, y, band);
        }
        if (img instanceof MultiSpectral) {
            return GeneralizedImageOps.get(((MultiSpectral)img).getBand(band), x, y);
        }
        throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
    }

    public static double get(ImageInterleaved img, int x, int y, int band) {
        if (img instanceof InterleavedU8) {
            return ((InterleavedU8)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS8) {
            return ((InterleavedS8)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS16) {
            return ((InterleavedS16)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedU16) {
            return ((InterleavedU16)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS32) {
            return ((InterleavedS32)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS64) {
            return ((InterleavedS64)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedF32) {
            return ((InterleavedF32)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedF64) {
            return ((InterleavedF64)img).getBand(x, y, band);
        }
        throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
    }

    public static <T extends ImageSingleBand> T createSingleBand(ImageDataType type, int width, int height) {
        Class typeClass = ImageType.getImageClass(ImageType.Family.SINGLE_BAND, type);
        return GeneralizedImageOps.createSingleBand(typeClass, width, height);
    }

    public static <T extends ImageSingleBand> T createSingleBand(Class<T> type, int width, int height) {
        if ((type = (Class)BoofTesting.convertGenericToSpecificType(type)) == ImageUInt8.class) {
            return (T)new ImageUInt8(width, height);
        }
        if (type == ImageSInt8.class) {
            return (T)new ImageSInt8(width, height);
        }
        if (type == ImageSInt16.class) {
            return (T)new ImageSInt16(width, height);
        }
        if (type == ImageUInt16.class) {
            return (T)new ImageUInt16(width, height);
        }
        if (type == ImageSInt32.class) {
            return (T)new ImageSInt32(width, height);
        }
        if (type == ImageSInt64.class) {
            return (T)new ImageSInt64(width, height);
        }
        if (type == ImageFloat32.class) {
            return (T)new ImageFloat32(width, height);
        }
        if (type == ImageFloat64.class) {
            return (T)new ImageFloat64(width, height);
        }
        if (type == ImageInteger.class) {
            return (T)new ImageSInt32(width, height);
        }
        throw new RuntimeException("Unknown type: " + type.getSimpleName());
    }

    public static <T extends ImageInterleaved> T createInterleaved(ImageDataType type, int width, int height, int numBands) {
        Class typeClass = ImageType.getImageClass(ImageType.Family.INTERLEAVED, type);
        return GeneralizedImageOps.createInterleaved(typeClass, width, height, numBands);
    }

    public static <T extends ImageInterleaved> T createInterleaved(Class<T> type, int width, int height, int numBands) {
        if ((type = (Class)BoofTesting.convertGenericToSpecificType(type)) == InterleavedU8.class) {
            return (T)new InterleavedU8(width, height, numBands);
        }
        if (type == InterleavedS8.class) {
            return (T)new InterleavedS8(width, height, numBands);
        }
        if (type == InterleavedU16.class) {
            return (T)new InterleavedU16(width, height, numBands);
        }
        if (type == InterleavedS16.class) {
            return (T)new InterleavedS16(width, height, numBands);
        }
        if (type == InterleavedS32.class) {
            return (T)new InterleavedS32(width, height, numBands);
        }
        if (type == InterleavedS64.class) {
            return (T)new InterleavedS64(width, height, numBands);
        }
        if (type == InterleavedF32.class) {
            return (T)new InterleavedF32(width, height, numBands);
        }
        if (type == InterleavedF64.class) {
            return (T)new InterleavedF64(width, height, numBands);
        }
        if (type == ImageInterleaved.class) {
            return (T)new InterleavedS32(width, height, numBands);
        }
        throw new RuntimeException("Unknown type: " + type.getSimpleName());
    }

    public static void set(ImageSingleBand img, int x, int y, double value) {
        if (ImageInteger.class.isAssignableFrom(img.getClass())) {
            ((ImageInteger)img).set(x, y, (int)value);
        } else if (img instanceof ImageFloat32) {
            ((ImageFloat32)img).set(x, y, (float)value);
        } else if (img instanceof ImageFloat64) {
            ((ImageFloat64)img).set(x, y, value);
        } else {
            throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> int getNumBits(Class<T> type) {
        if (type == ImageUInt8.class) {
            return 8;
        }
        if (type == ImageSInt8.class) {
            return 8;
        }
        if (type == ImageSInt16.class) {
            return 16;
        }
        if (type == ImageUInt16.class) {
            return 16;
        }
        if (type == ImageSInt32.class) {
            return 32;
        }
        if (type == ImageSInt64.class) {
            return 64;
        }
        if (type == ImageFloat32.class) {
            return 32;
        }
        if (type == ImageFloat64.class) {
            return 64;
        }
        throw new RuntimeException("Unknown type: " + type.getSimpleName());
    }
}

