/*
 * Copyright (c) 2011-2013, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.alg.distort;

import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.distort.PointTransform_F32;
import georegression.struct.point.Point2D_F32;

/**
 * Allows a {@link PointToPixelTransform_F32} to be invoked as a {@link boofcv.struct.distort.PixelTransform_F32}.
 * 
 * @author Peter Abeles
 */
public class PointToPixelTransform_F32 extends PixelTransform_F32 {
	PointTransform_F32 alg;

	Point2D_F32 point = new Point2D_F32();

	public PointToPixelTransform_F32(PointTransform_F32 alg) {
		this.alg = alg;
	}

	@Override
	public void compute(int x, int y) {
		alg.compute(x,y,point);
		distX = point.x;
		distY = point.y;
	}
}
