/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.blur;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.testing.BoofTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MedianImageFilter<T extends ImageSingleBand>
implements BlurFilter<T> {
    private Method m;
    private int radius;
    Class<T> imageType;

    public MedianImageFilter(Class<T> imageType, int radius) {
        this.radius = radius;
        this.imageType = imageType;
        this.m = BoofTesting.findMethod(BlurImageOps.class, "median", imageType, imageType, Integer.TYPE);
        if (this.m == null) {
            throw new IllegalArgumentException("Can't find matching function for image type " + imageType.getSimpleName());
        }
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void process(T input, T output) {
        try {
            this.m.invoke(null, input, output, this.radius);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return ImageType.single(this.imageType);
    }

    @Override
    public ImageType<T> getOutputType() {
        return ImageType.single(this.imageType);
    }
}

