/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.NearestNeighborPixel;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageType;

public class NearestNeighborPixel_S16
extends NearestNeighborPixel<ImageSInt16> {
    private short[] data;

    public NearestNeighborPixel_S16() {
    }

    public NearestNeighborPixel_S16(ImageSInt16 orig) {
        this.setImage(orig);
    }

    @Override
    public void setImage(ImageSInt16 image) {
        this.orig = image;
        this.data = ((ImageSInt16)this.orig).data;
        this.stride = ((ImageSInt16)this.orig).getStride();
        this.width = ((ImageSInt16)this.orig).getWidth();
        this.height = ((ImageSInt16)this.orig).getHeight();
    }

    @Override
    public float get_fast(float x, float y) {
        return this.data[((ImageSInt16)this.orig).startIndex + (int)y * this.stride + (int)x];
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            throw new IllegalArgumentException("Point is outside of the image");
        }
        int xx = (int)x;
        int yy = (int)y;
        return this.data[((ImageSInt16)this.orig).startIndex + yy * this.stride + xx];
    }

    @Override
    public ImageType<ImageSInt16> getImageType() {
        return ImageType.single(ImageSInt16.class);
    }
}

