/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.core.image.border.ImageBorderValue;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.image.ImageUInt8;

public class ImplBinaryBorderOps {
    public static void erode4(ImageUInt8 input, ImageUInt8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap(input, 1);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x, 0) + in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x, 1) == 4) {
                output.set(x, 0, 1);
            } else {
                output.set(x, 0, 0);
            }
            if (in.get(x, h) + in.get(x - 1, h) + in.get(x + 1, h) + in.get(x, h - 1) == 4) {
                output.set(x, h, 1);
                continue;
            }
            output.set(x, h, 0);
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(0, y) + in.get(1, y) + in.get(0, y - 1) + in.get(0, y + 1) == 4) {
                output.set(0, y, 1);
            } else {
                output.set(0, y, 0);
            }
            if (in.get(w, y) + in.get(w - 1, y) + in.get(w, y - 1) + in.get(w, y + 1) == 4) {
                output.set(w, y, 1);
                continue;
            }
            output.set(w, y, 0);
        }
    }

    public static void dilate4(ImageUInt8 input, ImageUInt8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap(input, 0);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x, 0) + in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x, 1) > 0) {
                output.set(x, 0, 1);
            } else {
                output.set(x, 0, 0);
            }
            if (in.get(x, h) + in.get(x - 1, h) + in.get(x + 1, h) + in.get(x, h - 1) > 0) {
                output.set(x, h, 1);
                continue;
            }
            output.set(x, h, 0);
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(0, y) + in.get(1, y) + in.get(0, y - 1) + in.get(0, y + 1) > 0) {
                output.set(0, y, 1);
            } else {
                output.set(0, y, 0);
            }
            if (in.get(w, y) + in.get(w - 1, y) + in.get(w, y - 1) + in.get(w, y + 1) > 0) {
                output.set(w, y, 1);
                continue;
            }
            output.set(w, y, 0);
        }
    }

    public static ImageUInt8 edge4(ImageUInt8 input, ImageUInt8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap(input, 1);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x, 1) == 3) {
                output.set(x, 0, 0);
            } else {
                output.set(x, 0, input.get(x, 0));
            }
            if (in.get(x - 1, h) + in.get(x + 1, h) + in.get(x, h - 1) == 3) {
                output.set(x, h, 0);
                continue;
            }
            output.set(x, h, input.get(x, h));
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(1, y) + in.get(0, y - 1) + in.get(0, y + 1) == 3) {
                output.set(0, y, 0);
            } else {
                output.set(0, y, input.get(0, y));
            }
            if (in.get(w - 1, y) + in.get(w, y - 1) + in.get(w, y + 1) == 3) {
                output.set(w, y, 0);
                continue;
            }
            output.set(w, y, input.get(w, y));
        }
        return output;
    }

    public static void erode8(ImageUInt8 input, ImageUInt8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap(input, 1);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x, 0) + in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x - 1, 1) + in.get(x, 1) + in.get(x + 1, 1) == 6) {
                output.set(x, 0, 1);
            } else {
                output.set(x, 0, 0);
            }
            if (in.get(x, h) + in.get(x - 1, h) + in.get(x + 1, h) + in.get(x - 1, h - 1) + in.get(x, h - 1) + in.get(x + 1, h - 1) == 6) {
                output.set(x, h, 1);
                continue;
            }
            output.set(x, h, 0);
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(0, y) + in.get(1, y) + in.get(0, y - 1) + in.get(1, y - 1) + in.get(0, y + 1) + in.get(1, y + 1) == 6) {
                output.set(0, y, 1);
            } else {
                output.set(0, y, 0);
            }
            if (in.get(w - 1, y) + in.get(w, y) + in.get(w - 1, y - 1) + in.get(w, y - 1) + in.get(w - 1, y + 1) + in.get(w, y + 1) == 6) {
                output.set(w, y, 1);
                continue;
            }
            output.set(w, y, 0);
        }
    }

    public static void dilate8(ImageUInt8 input, ImageUInt8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap(input, 0);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x, 0) + in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x - 1, 1) + in.get(x, 1) + in.get(x + 1, 1) > 0) {
                output.set(x, 0, 1);
            } else {
                output.set(x, 0, 0);
            }
            if (in.get(x, h) + in.get(x - 1, h) + in.get(x + 1, h) + in.get(x - 1, h - 1) + in.get(x, h - 1) + in.get(x + 1, h - 1) > 0) {
                output.set(x, h, 1);
                continue;
            }
            output.set(x, h, 0);
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(0, y) + in.get(1, y) + in.get(0, y - 1) + in.get(1, y - 1) + in.get(0, y + 1) + in.get(1, y + 1) > 0) {
                output.set(0, y, 1);
            } else {
                output.set(0, y, 0);
            }
            if (in.get(w - 1, y) + in.get(w, y) + in.get(w - 1, y - 1) + in.get(w, y - 1) + in.get(w - 1, y + 1) + in.get(w, y + 1) > 0) {
                output.set(w, y, 1);
                continue;
            }
            output.set(w, y, 0);
        }
    }

    public static void edge8(ImageUInt8 input, ImageUInt8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap(input, 1);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x - 1, 1) + in.get(x, 1) + in.get(x + 1, 1) == 5) {
                output.set(x, 0, 0);
            } else {
                output.set(x, 0, input.get(x, 0));
            }
            if (in.get(x - 1, h) + in.get(x + 1, h) + in.get(x - 1, h - 1) + in.get(x, h - 1) + in.get(x + 1, h - 1) == 5) {
                output.set(x, h, 0);
                continue;
            }
            output.set(x, h, input.get(x, h));
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(1, y) + in.get(0, y - 1) + in.get(1, y - 1) + in.get(0, y + 1) + in.get(1, y + 1) == 5) {
                output.set(0, y, 0);
            } else {
                output.set(0, y, input.get(0, y));
            }
            if (in.get(w - 1, y) + in.get(w - 1, y - 1) + in.get(w, y - 1) + in.get(w - 1, y + 1) + in.get(w, y + 1) == 5) {
                output.set(w, y, 0);
                continue;
            }
            output.set(w, y, input.get(w, y));
        }
    }

    public static void removePointNoise(ImageUInt8 input, ImageUInt8 output) {
        int total;
        ImageBorder_S32 in = ImageBorderValue.wrap(input, 0);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            total = in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x - 1, 1) + in.get(x, 1) + in.get(x + 1, 1);
            if (total < 2) {
                output.set(x, 0, 0);
            } else {
                output.set(x, 0, input.get(x, 0));
            }
            total = in.get(x - 1, h) + in.get(x + 1, h) + in.get(x - 1, h - 1) + in.get(x, h - 1) + in.get(x + 1, h - 1);
            if (total < 2) {
                output.set(x, h, 0);
                continue;
            }
            output.set(x, h, input.get(x, h));
        }
        for (int y = 0; y < input.height; ++y) {
            total = in.get(1, y) + in.get(0, y - 1) + in.get(1, y - 1) + in.get(0, y + 1) + in.get(1, y + 1);
            if (total < 2) {
                output.set(0, y, 0);
            } else {
                output.set(0, y, input.get(0, y));
            }
            total = in.get(w - 1, y) + in.get(w - 1, y - 1) + in.get(w, y - 1) + in.get(w - 1, y + 1) + in.get(w, y + 1);
            if (total < 2) {
                output.set(w, y, 0);
                continue;
            }
            output.set(w, y, input.get(w, y));
        }
    }
}

