/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.border.ConvolveJustBorder_General;
import boofcv.alg.filter.derivative.DerivativeHelperFunctions;
import boofcv.alg.filter.derivative.impl.HessianThree_Standard;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class HessianThree {
    public static Kernel1D_I32 kernelXXYY_I32 = new Kernel1D_I32(new int[]{1, 0, -2, 0, 1}, 5);
    public static Kernel2D_I32 kernelCross_I32 = new Kernel2D_I32(3, new int[]{1, 0, -1, 0, 0, 0, -1, 0, 1});
    public static Kernel1D_F32 kernelXXYY_F32 = new Kernel1D_F32(new float[]{0.5f, 0.0f, -1.0f, 0.0f, 0.5f}, 5);
    public static Kernel2D_F32 kernelCross_F32 = new Kernel2D_F32(3, new float[]{0.5f, 0.0f, -0.5f, 0.0f, 0.0f, 0.0f, -0.5f, 0.0f, 0.5f});

    public static void process(ImageUInt8 orig, ImageSInt16 derivXX, ImageSInt16 derivYY, ImageSInt16 derivXY, ImageBorder_S32 border) {
        InputSanityCheck.checkSameShape(orig, derivXX, derivYY, derivXY);
        HessianThree_Standard.process(orig, derivXX, derivYY, derivXY);
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivXX, kernelXXYY_I32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivYY, kernelXXYY_I32, border);
            ConvolveJustBorder_General.convolve(kernelCross_I32, border, derivXY);
        }
    }

    public static void process(ImageFloat32 orig, ImageFloat32 derivXX, ImageFloat32 derivYY, ImageFloat32 derivXY, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(orig, derivXX, derivYY, derivXY);
        HessianThree_Standard.process(orig, derivXX, derivYY, derivXY);
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivXX, kernelXXYY_F32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivYY, kernelXXYY_F32, border);
            ConvolveJustBorder_General.convolve(kernelCross_F32, border, derivXY);
        }
    }
}

