/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.sparse.GradientValue_I32;
import boofcv.struct.sparse.SparseImageGradient;

public class GradientSparseSobel_U8
implements SparseImageGradient<ImageUInt8, GradientValue_I32> {
    ImageUInt8 input;
    ImageBorder_S32<ImageUInt8> border;
    GradientValue_I32 gradient = new GradientValue_I32();

    public GradientSparseSobel_U8(ImageBorder_S32<ImageUInt8> border) {
        this.border = border;
    }

    @Override
    public GradientValue_I32 compute(int x, int y) {
        int a22;
        int a21;
        int a20;
        int a12;
        int a10;
        int a02;
        int a01;
        int a00;
        if (x >= 1 && y >= 1 && x < this.input.width - 1 && y < this.input.height - 1) {
            int s = this.input.stride;
            int tl = this.input.startIndex + this.input.stride * (y - 1) + x - 1;
            a00 = this.input.data[tl] & 0xFF;
            a01 = this.input.data[tl + 1] & 0xFF;
            a02 = this.input.data[tl + 2] & 0xFF;
            a10 = this.input.data[tl + s] & 0xFF;
            a12 = this.input.data[tl + 2 + s] & 0xFF;
            a20 = this.input.data[tl + 2 * s] & 0xFF;
            a21 = this.input.data[tl + 1 + 2 * s] & 0xFF;
            a22 = this.input.data[tl + 2 + 2 * s] & 0xFF;
        } else {
            a00 = this.border.get(x - 1, y - 1);
            a01 = this.border.get(x, y - 1);
            a02 = this.border.get(x + 1, y - 1);
            a10 = this.border.get(x - 1, y);
            a12 = this.border.get(x + 1, y);
            a20 = this.border.get(x - 1, y + 1);
            a21 = this.border.get(x, y + 1);
            a22 = this.border.get(x + 1, y + 1);
        }
        this.gradient.y = -(a00 + 2 * a01 + a02);
        this.gradient.y += a20 + 2 * a21 + a22;
        this.gradient.x = -(a00 + 2 * a10 + a20);
        this.gradient.x += a02 + 2 * a12 + a22;
        return this.gradient;
    }

    @Override
    public Class<GradientValue_I32> getGradientType() {
        return GradientValue_I32.class;
    }

    @Override
    public void setImage(ImageUInt8 input) {
        this.input = input;
        if (this.border != null) {
            this.border.setImage(input);
        }
    }

    @Override
    public boolean isInBounds(int x, int y) {
        return this.border != null || x >= 1 && y >= 1 && x < this.input.width - 1 && y < this.input.height - 1;
    }
}

