/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;
import java.util.Random;

public class GImageMiscOps {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, ImageBase input, ImageBase output) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageInt8)input, (ImageInt8)output);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageInt16)input, (ImageInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageSInt32)input, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageSInt64)input, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageFloat32)input, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (ImageFloat64)input, (ImageFloat64)output);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral mi = (MultiSpectral)input;
            MultiSpectral mo = (MultiSpectral)output;
            for (int i = 0; i < mi.getNumBands(); ++i) {
                GImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, mi.getBand(i), mo.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fill(ImageBase input, double value) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((ImageInt8)input, (int)value);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((ImageInt16)input, (int)value);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fill((ImageSInt32)input, (int)value);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fill((ImageSInt64)input, (long)value);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fill((ImageFloat32)input, (float)value);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fill((ImageFloat64)input, value);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((InterleavedI8)input, (int)value);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((InterleavedI16)input, (int)value);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedS32)input, (int)value);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedS64)input, (long)value);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedF32)input, (float)value);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fill((InterleavedF64)input, value);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fill(m.getBand(i), value);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fill(ImageBase input, double[] values) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((ImageInt8)input, (int)values[0]);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((ImageInt16)input, (int)values[0]);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fill((ImageSInt32)input, (int)values[0]);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fill((ImageSInt64)input, (long)values[0]);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fill((ImageFloat32)input, (float)values[0]);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fill((ImageFloat64)input, values[0]);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((InterleavedI8)input, BoofMiscOps.convertArray(values, (int[])null));
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((InterleavedI16)input, BoofMiscOps.convertArray(values, (int[])null));
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedS32)input, BoofMiscOps.convertArray(values, (int[])null));
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedS64)input, BoofMiscOps.convertArray(values, (long[])null));
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedF32)input, BoofMiscOps.convertArray(values, (float[])null));
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fill((InterleavedF64)input, values);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fill(m.getBand(i), values[i]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillBand(ImageMultiBand input, int band, double value) {
        if (input instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillBand((InterleavedI8)input, band, (int)value);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillBand((InterleavedI16)input, band, (int)value);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fillBand((InterleavedS32)input, band, (int)value);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fillBand((InterleavedS64)input, band, (long)value);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fillBand((InterleavedF32)input, band, (float)value);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillBand((InterleavedF64)input, band, value);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            GImageMiscOps.fill(m.getBand(band), value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void insertBand(ImageSingleBand input, int band, ImageMultiBand output) {
        if (output instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(output.getClass())) {
                ImageMiscOps.insertBand((ImageInt8)input, band, (InterleavedI8)output);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(output.getClass())) {
                ImageMiscOps.insertBand((ImageInt16)input, band, (InterleavedI16)output);
                return;
            } else if (InterleavedS32.class == output.getClass()) {
                ImageMiscOps.insertBand((ImageSInt32)input, band, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == output.getClass()) {
                ImageMiscOps.insertBand((ImageSInt64)input, band, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == output.getClass()) {
                ImageMiscOps.insertBand((ImageFloat32)input, band, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != output.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.insertBand((ImageFloat64)input, band, (InterleavedF64)output);
            }
            return;
        } else {
            if (!(output instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)output;
            m.getBand(band).setTo((ImageSingleBand)input);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillBorder(ImageBase input, double value, int radius) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillBorder((ImageInt8)input, (int)value, radius);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillBorder((ImageInt16)input, (int)value, radius);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fillBorder((ImageSInt32)input, (int)value, radius);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fillBorder((ImageSInt64)input, (long)value, radius);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fillBorder((ImageFloat32)input, (float)value, radius);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillBorder((ImageFloat64)input, value, radius);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillBorder(m.getBand(i), value, radius);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillRectangle(ImageBase input, double value, int x0, int y0, int width, int height) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillRectangle((ImageInt8)input, (int)value, x0, y0, width, height);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillRectangle((ImageInt16)input, (int)value, x0, y0, width, height);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fillRectangle((ImageSInt32)input, (int)value, x0, y0, width, height);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fillRectangle((ImageSInt64)input, (long)value, x0, y0, width, height);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fillRectangle((ImageFloat32)input, (float)value, x0, y0, width, height);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillRectangle((ImageFloat64)input, value, x0, y0, width, height);
            }
            return;
        } else if (input instanceof MultiSpectral) {
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillRectangle(m.getBand(i), value, x0, y0, width, height);
            }
            return;
        } else {
            if (!(input instanceof ImageInterleaved)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillRectangle((InterleavedI8)input, (byte)value, x0, y0, width, height);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillRectangle((InterleavedI16)input, (short)value, x0, y0, width, height);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fillRectangle((InterleavedS32)input, (int)value, x0, y0, width, height);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fillRectangle((InterleavedS64)input, (long)value, x0, y0, width, height);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fillRectangle((InterleavedF32)input, (float)value, x0, y0, width, height);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillRectangle((InterleavedF64)input, value, x0, y0, width, height);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillGaussian(ImageBase input, Random rand, double mean, double sigma, double lowerBound, double upperBound) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillGaussian((ImageInt8)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillGaussian((ImageInt16)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fillGaussian((ImageSInt32)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fillGaussian((ImageSInt64)input, rand, mean, sigma, (long)lowerBound, (long)upperBound);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fillGaussian((ImageFloat32)input, rand, mean, sigma, (float)lowerBound, (float)upperBound);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillGaussian((ImageFloat64)input, rand, mean, sigma, lowerBound, upperBound);
            }
            return;
        } else if (input instanceof MultiSpectral) {
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
            }
            return;
        } else {
            if (!(input instanceof ImageInterleaved)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillGaussian((InterleavedI8)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillGaussian((InterleavedI16)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fillGaussian((InterleavedS32)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fillGaussian((InterleavedS64)input, rand, mean, sigma, (long)lowerBound, (long)upperBound);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fillGaussian((InterleavedF32)input, rand, mean, sigma, (float)lowerBound, (float)upperBound);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillGaussian((InterleavedF64)input, rand, mean, sigma, lowerBound, upperBound);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillUniform(ImageBase input, Random rand, double min, double max) {
        if (input instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((ImageInt8)input, rand, (int)min, (int)max - 1);
                return;
            } else if (ImageInt16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((ImageInt16)input, rand, (int)min, (int)max - 1);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.fillUniform((ImageSInt32)input, rand, (int)min, (int)max - 1);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.fillUniform((ImageSInt64)input, rand, (long)min, (long)max - 1L);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.fillUniform((ImageFloat32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillUniform((ImageFloat64)input, rand, min, max);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((InterleavedI8)input, rand, (int)min, (int)max - 1);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((InterleavedI16)input, rand, (int)min, (int)max - 1);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fillUniform((InterleavedS32)input, rand, (int)min, (int)max - 1);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fillUniform((InterleavedS64)input, rand, (long)min, (long)max - 1L);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fillUniform((InterleavedF32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillUniform((InterleavedF64)input, rand, min, max);
            }
            return;
        } else {
            if (!(input instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillUniform(m.getBand(i), rand, min, max);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addGaussian(ImageBase input, Random rand, double sigma, double lowerBound, double upperBound) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageUInt8)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageSInt8)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageUInt16)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageSInt16)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageSInt32)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageSInt64)input, rand, sigma, (long)lowerBound, (long)upperBound);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.addGaussian((ImageFloat32)input, rand, sigma, (float)lowerBound, (float)upperBound);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.addGaussian((ImageFloat64)input, rand, sigma, lowerBound, upperBound);
            }
            return;
        } else if (input instanceof MultiSpectral) {
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.addGaussian(m.getBand(i), rand, sigma, lowerBound, upperBound);
            }
            return;
        } else {
            if (!(input instanceof ImageInterleaved)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            if (InterleavedU8.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedU8)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedS8)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedU16)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedS16)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedS32)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedS64)input, rand, sigma, (long)lowerBound, (long)upperBound);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedF32)input, rand, sigma, (float)lowerBound, (float)upperBound);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.addGaussian((InterleavedF64)input, rand, sigma, lowerBound, upperBound);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addUniform(ImageBase input, Random rand, double min, double max) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageUInt8)input, rand, (int)min, (int)max);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageSInt8)input, rand, (int)min, (int)max);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageUInt16)input, rand, (int)min, (int)max);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageSInt16)input, rand, (int)min, (int)max);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageSInt32)input, rand, (int)min, (int)max);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageSInt64)input, rand, (long)min, (long)max);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                ImageMiscOps.addUniform((ImageFloat32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.addUniform((ImageFloat64)input, rand, min, max);
            }
            return;
        } else if (input instanceof MultiSpectral) {
            MultiSpectral m = (MultiSpectral)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.addUniform(m.getBand(i), rand, min, max);
            }
            return;
        } else {
            if (!(input instanceof ImageInterleaved)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            if (InterleavedU8.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedU8)input, rand, (int)min, (int)max);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedS8)input, rand, (int)min, (int)max);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedU16)input, rand, (int)min, (int)max);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedS16)input, rand, (int)min, (int)max);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedS32)input, rand, (int)min, (int)max);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedS64)input, rand, (long)min, (long)max);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedF32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.addUniform((InterleavedF64)input, rand, min, max);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void flipVertical(ImageBase img) {
        if (img instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageInt8)img);
                return;
            } else if (ImageInt16.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageInt16)img);
                return;
            } else if (ImageSInt32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageSInt32)img);
                return;
            } else if (ImageSInt64.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageSInt64)img);
                return;
            } else if (ImageFloat32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageFloat32)img);
                return;
            } else if (ImageFloat64.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((ImageFloat64)img);
                return;
            } else {
                if (!ImageSInt64.class.isAssignableFrom(img.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
                ImageMiscOps.flipVertical((ImageSInt64)img);
            }
            return;
        } else {
            if (!(img instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + img.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)img;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.flipVertical(m.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void flipHorizontal(ImageBase img) {
        if (img instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageInt8)img);
                return;
            } else if (ImageInt16.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageInt16)img);
                return;
            } else if (ImageSInt32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageSInt32)img);
                return;
            } else if (ImageSInt64.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageSInt64)img);
                return;
            } else if (ImageFloat32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageFloat32)img);
                return;
            } else if (ImageFloat64.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((ImageFloat64)img);
                return;
            } else {
                if (!ImageSInt64.class.isAssignableFrom(img.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
                ImageMiscOps.flipHorizontal((ImageSInt64)img);
            }
            return;
        } else {
            if (!(img instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + img.getClass().getSimpleName());
            MultiSpectral m = (MultiSpectral)img;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.flipHorizontal(m.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rotateCW(ImageBase image) {
        if (image instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((ImageInt8)image);
                return;
            } else if (ImageInt16.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((ImageInt16)image);
                return;
            } else if (ImageSInt32.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((ImageSInt32)image);
                return;
            } else if (ImageSInt64.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((ImageSInt64)image);
                return;
            } else if (ImageFloat32.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((ImageFloat32)image);
                return;
            } else if (ImageFloat64.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((ImageFloat64)image);
                return;
            } else {
                if (!ImageSInt64.class.isAssignableFrom(image.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + image.getClass().getSimpleName());
                ImageMiscOps.rotateCW((ImageSInt64)image);
            }
            return;
        } else {
            if (!(image instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + image.getClass().getSimpleName());
            MultiSpectral a = (MultiSpectral)image;
            for (int i = 0; i < a.getNumBands(); ++i) {
                GImageMiscOps.rotateCW(a.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rotateCW(ImageBase imageA, ImageBase imageB) {
        if (imageA instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((ImageInt8)imageA, (ImageInt8)imageB);
                return;
            } else if (ImageInt16.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((ImageInt16)imageA, (ImageInt16)imageB);
                return;
            } else if (ImageSInt32.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((ImageSInt32)imageA, (ImageSInt32)imageB);
                return;
            } else if (ImageSInt64.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((ImageSInt64)imageA, (ImageSInt64)imageB);
                return;
            } else if (ImageFloat32.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((ImageFloat32)imageA, (ImageFloat32)imageB);
                return;
            } else if (ImageFloat64.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((ImageFloat64)imageA, (ImageFloat64)imageB);
                return;
            } else {
                if (!ImageSInt64.class.isAssignableFrom(imageA.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + imageA.getClass().getSimpleName());
                ImageMiscOps.rotateCW((ImageSInt64)imageA, (ImageSInt64)imageB);
            }
            return;
        } else {
            if (!(imageA instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + imageA.getClass().getSimpleName());
            MultiSpectral a = (MultiSpectral)imageA;
            MultiSpectral b = (MultiSpectral)imageB;
            for (int i = 0; i < a.getNumBands(); ++i) {
                GImageMiscOps.rotateCW(a.getBand(i), b.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rotateCCW(ImageBase image) {
        if (image instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((ImageInt8)image);
                return;
            } else if (ImageInt16.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((ImageInt16)image);
                return;
            } else if (ImageSInt32.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((ImageSInt32)image);
                return;
            } else if (ImageSInt64.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((ImageSInt64)image);
                return;
            } else if (ImageFloat32.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((ImageFloat32)image);
                return;
            } else if (ImageFloat64.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((ImageFloat64)image);
                return;
            } else {
                if (!ImageSInt64.class.isAssignableFrom(image.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + image.getClass().getSimpleName());
                ImageMiscOps.rotateCCW((ImageSInt64)image);
            }
            return;
        } else {
            if (!(image instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + image.getClass().getSimpleName());
            MultiSpectral a = (MultiSpectral)image;
            for (int i = 0; i < a.getNumBands(); ++i) {
                GImageMiscOps.rotateCCW(a.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rotateCCW(ImageBase imageA, ImageBase imageB) {
        if (imageA instanceof ImageSingleBand) {
            if (ImageInt8.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((ImageInt8)imageA, (ImageInt8)imageB);
                return;
            } else if (ImageInt16.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((ImageInt16)imageA, (ImageInt16)imageB);
                return;
            } else if (ImageSInt32.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((ImageSInt32)imageA, (ImageSInt32)imageB);
                return;
            } else if (ImageSInt64.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((ImageSInt64)imageA, (ImageSInt64)imageB);
                return;
            } else if (ImageFloat32.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((ImageFloat32)imageA, (ImageFloat32)imageB);
                return;
            } else if (ImageFloat64.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((ImageFloat64)imageA, (ImageFloat64)imageB);
                return;
            } else {
                if (!ImageSInt64.class.isAssignableFrom(imageA.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + imageA.getClass().getSimpleName());
                ImageMiscOps.rotateCCW((ImageSInt64)imageA, (ImageSInt64)imageB);
            }
            return;
        } else {
            if (!(imageA instanceof MultiSpectral)) throw new IllegalArgumentException("Unknown image type: " + imageA.getClass().getSimpleName());
            MultiSpectral a = (MultiSpectral)imageA;
            MultiSpectral b = (MultiSpectral)imageB;
            for (int i = 0; i < a.getNumBands(); ++i) {
                GImageMiscOps.rotateCCW(a.getBand(i), b.getBand(i));
            }
        }
    }
}

