/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.fft;

import boofcv.abst.transform.fft.DiscreteFourierTransform;
import boofcv.alg.transform.fft.DiscreteFourierTransformOps;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageFloat;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;

public class GDiscreteFourierTransformOps {
    public static <T extends ImageFloat, W extends ImageInterleaved> DiscreteFourierTransform<T, W> createTransform(ImageDataType type) {
        switch (type) {
            case F32: {
                return DiscreteFourierTransformOps.createTransformF32();
            }
            case F64: {
                return DiscreteFourierTransformOps.createTransformF64();
            }
        }
        throw new IllegalArgumentException("Unsupported image type " + (Object)((Object)type));
    }

    public static void shiftZeroFrequency(ImageInterleaved transform, boolean forward) {
        if (transform instanceof InterleavedF32) {
            DiscreteFourierTransformOps.shiftZeroFrequency((InterleavedF32)transform, forward);
        } else if (transform instanceof InterleavedF64) {
            DiscreteFourierTransformOps.shiftZeroFrequency((InterleavedF64)transform, forward);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
    }

    public static void magnitude(ImageInterleaved transform, ImageFloat magnitude) {
        if (transform instanceof InterleavedF32) {
            DiscreteFourierTransformOps.magnitude((InterleavedF32)transform, (ImageFloat32)magnitude);
        } else if (transform instanceof InterleavedF64) {
            DiscreteFourierTransformOps.magnitude((InterleavedF64)transform, (ImageFloat64)magnitude);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
    }

    public static void phase(ImageInterleaved transform, ImageFloat phase) {
        if (transform instanceof InterleavedF32) {
            DiscreteFourierTransformOps.phase((InterleavedF32)transform, (ImageFloat32)phase);
        } else if (transform instanceof InterleavedF64) {
            DiscreteFourierTransformOps.phase((InterleavedF64)transform, (ImageFloat64)phase);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
    }

    public static void realToComplex(ImageFloat real, ImageInterleaved complex) {
        if (complex instanceof InterleavedF32) {
            DiscreteFourierTransformOps.realToComplex((ImageFloat32)real, (InterleavedF32)complex);
        } else if (complex instanceof InterleavedF64) {
            DiscreteFourierTransformOps.realToComplex((ImageFloat64)real, (InterleavedF64)complex);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
    }

    public static void multiplyRealComplex(ImageFloat realA, ImageInterleaved complexB, ImageInterleaved complexC) {
        if (complexB instanceof InterleavedF32) {
            DiscreteFourierTransformOps.multiplyRealComplex((ImageFloat32)realA, (InterleavedF32)complexB, (InterleavedF32)complexC);
        } else if (complexB instanceof InterleavedF64) {
            DiscreteFourierTransformOps.multiplyRealComplex((ImageFloat64)realA, (InterleavedF64)complexB, (InterleavedF64)complexC);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
    }

    public static void multiplyComplex(ImageInterleaved complexA, ImageInterleaved complexB, ImageInterleaved complexC) {
        if (complexB instanceof InterleavedF32) {
            DiscreteFourierTransformOps.multiplyComplex((InterleavedF32)complexA, (InterleavedF32)complexB, (InterleavedF32)complexC);
        } else if (complexB instanceof InterleavedF64) {
            DiscreteFourierTransformOps.multiplyComplex((InterleavedF64)complexA, (InterleavedF64)complexB, (InterleavedF64)complexC);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
    }
}

