/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.core.image.FactoryGImageSingleBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.core.image.GImageSingleBand;
import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder_IL_F32;
import boofcv.core.image.border.ImageBorder_IL_F64;
import boofcv.core.image.border.ImageBorder_IL_S32;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;

public class FactoryGImageMultiBand {
    public static GImageMultiBand wrap(ImageBase image) {
        if (image instanceof ImageSingleBand) {
            return FactoryGImageMultiBand.wrap((ImageSingleBand)image);
        }
        if (image instanceof MultiSpectral) {
            return FactoryGImageMultiBand.wrap((MultiSpectral)image);
        }
        if (image instanceof ImageInterleaved) {
            return FactoryGImageMultiBand.wrap((ImageInterleaved)image);
        }
        throw new RuntimeException("Unknown image type");
    }

    public static GImageMultiBand wrap(ImageSingleBand image) {
        return new GSingleToMB(FactoryGImageSingleBand.wrap(image));
    }

    public static GImageMultiBand create(ImageType imageType) {
        if (imageType.getFamily() == ImageType.Family.MULTI_SPECTRAL) {
            return new MS();
        }
        if (imageType.getFamily() == ImageType.Family.INTERLEAVED) {
            switch (imageType.getDataType()) {
                case U8: {
                    return new IL_U8();
                }
                case S8: {
                    return new IL_S8();
                }
                case F32: {
                    return new IL_F32();
                }
            }
            throw new IllegalArgumentException("Need to support more data types");
        }
        throw new RuntimeException("Add support for more families");
    }

    public static GImageMultiBand wrap(MultiSpectral image) {
        return new MS(image);
    }

    public static GImageMultiBand wrap(ImageInterleaved image) {
        switch (image.getDataType()) {
            case U8: {
                return new IL_U8((InterleavedU8)image);
            }
            case S8: {
                return new IL_S8((InterleavedS8)image);
            }
            case F32: {
                return new IL_F32((InterleavedF32)image);
            }
        }
        throw new IllegalArgumentException("Need to support more data types: " + (Object)((Object)image.getDataType()));
    }

    public static GImageMultiBand wrap(ImageBorder image) {
        if (image instanceof ImageBorder_IL_S32) {
            return new Border_IL_S32((ImageBorder_IL_S32)image);
        }
        if (image instanceof ImageBorder_IL_F32) {
            return new Border_IL_F32((ImageBorder_IL_F32)image);
        }
        if (image instanceof ImageBorder_IL_F64) {
            return new Border_IL_F64((ImageBorder_IL_F64)image);
        }
        throw new IllegalArgumentException("Not supported yet?");
    }

    public static abstract class GMultiBorder<T extends ImageBorder>
    implements GImageMultiBand {
        protected T image;

        public GMultiBorder(T image) {
            this.image = image;
        }

        @Override
        public void wrap(ImageBase image) {
            ((ImageBorder)((Object)this.image)).setImage((ImageBase)image);
        }

        @Override
        public int getWidth() {
            return ((ImageBase)((ImageBorder)this.image).getImage()).getWidth();
        }

        @Override
        public int getHeight() {
            return ((ImageBase)((ImageBorder)this.image).getImage()).getHeight();
        }

        public ImageMultiBand getImage() {
            return (ImageMultiBand)((ImageBorder)this.image).getImage();
        }

        @Override
        public void setF(int index, float[] value) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void getF(int index, float[] value) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public float getF(int index) {
            throw new RuntimeException("Not supported");
        }
    }

    public static class Border_IL_F64
    extends GMultiBorder<ImageBorder_IL_F64> {
        public Border_IL_F64(ImageBorder_IL_F64 image) {
            super(image);
        }

        @Override
        public int getNumberOfBands() {
            return ((ImageMultiBand)((ImageBorder_IL_F64)this.image).getImage()).getNumBands();
        }

        @Override
        public void set(int x, int y, float[] value) {
            double[] value_d = BoofMiscOps.convertArray(value, (double[])null);
            ((ImageBorder_IL_F64)this.image).set(x, y, value_d);
        }

        @Override
        public void get(int x, int y, float[] value) {
            double[] value_d = new double[value.length];
            ((ImageBorder_IL_F64)this.image).get(x, y, value_d);
            BoofMiscOps.convertArray(value_d, value);
        }
    }

    public static class Border_IL_F32
    extends GMultiBorder<ImageBorder_IL_F32> {
        public Border_IL_F32(ImageBorder_IL_F32 image) {
            super(image);
        }

        @Override
        public int getNumberOfBands() {
            return ((ImageMultiBand)((ImageBorder_IL_F32)this.image).getImage()).getNumBands();
        }

        @Override
        public void set(int x, int y, float[] value) {
            ((ImageBorder_IL_F32)this.image).set(x, y, value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            ((ImageBorder_IL_F32)this.image).get(x, y, value);
        }
    }

    public static class Border_IL_S32
    extends GMultiBorder<ImageBorder_IL_S32> {
        public Border_IL_S32(ImageBorder_IL_S32 image) {
            super(image);
        }

        @Override
        public int getNumberOfBands() {
            return ((ImageMultiBand)((ImageBorder_IL_S32)this.image).getImage()).getNumBands();
        }

        @Override
        public void set(int x, int y, float[] value) {
            int[] value_d = BoofMiscOps.convertArray(value, (int[])null);
            ((ImageBorder_IL_S32)this.image).set(x, y, value_d);
        }

        @Override
        public void get(int x, int y, float[] value) {
            int[] value_d = new int[value.length];
            ((ImageBorder_IL_S32)this.image).get(x, y, value_d);
            BoofMiscOps.convertArray(value_d, value);
        }
    }

    public static class IL_F32
    extends IL<InterleavedF32> {
        public IL_F32(InterleavedF32 image) {
            this.wrap(image);
        }

        public IL_F32() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedF32)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedF32)this.image).getIndex(x, y), value);
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedF32)this.image).getNumBands(); ++i) {
                ((InterleavedF32)this.image).data[index++] = value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedF32)this.image).getNumBands(); ++i) {
                value[i] = ((InterleavedF32)this.image).data[index++];
            }
        }

        @Override
        public float getF(int index) {
            return ((InterleavedF32)this.image).data[index];
        }
    }

    public static class IL_S8
    extends IL<InterleavedS8> {
        public IL_S8(InterleavedS8 image) {
            this.wrap(image);
        }

        public IL_S8() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedS8)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedS8)this.image).getIndex(x, y), value);
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedS8)this.image).getNumBands(); ++i) {
                ((InterleavedS8)this.image).data[index++] = (byte)value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedS8)this.image).getNumBands(); ++i) {
                value[i] = ((InterleavedS8)this.image).data[index++];
            }
        }

        @Override
        public float getF(int index) {
            return ((InterleavedS8)this.image).data[index];
        }
    }

    public static class IL_U8
    extends IL<InterleavedU8> {
        public IL_U8(InterleavedU8 image) {
            this.wrap(image);
        }

        public IL_U8() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedU8)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedU8)this.image).getIndex(x, y), value);
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedU8)this.image).getNumBands(); ++i) {
                ((InterleavedU8)this.image).data[index++] = (byte)value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedU8)this.image).getNumBands(); ++i) {
                value[i] = ((InterleavedU8)this.image).data[index++] & 0xFF;
            }
        }

        @Override
        public float getF(int index) {
            return ((InterleavedU8)this.image).data[index] & 0xFF;
        }
    }

    public static abstract class IL<T extends ImageInterleaved<T>>
    implements GImageMultiBand {
        T image;

        @Override
        public void wrap(ImageBase image) {
            this.image = (ImageInterleaved)image;
        }

        @Override
        public int getWidth() {
            return ((ImageBase)this.image).getWidth();
        }

        @Override
        public int getHeight() {
            return ((ImageBase)this.image).getHeight();
        }

        @Override
        public int getNumberOfBands() {
            return ((ImageInterleaved)this.image).getNumBands();
        }

        @Override
        public <T extends ImageBase> T getImage() {
            return this.image;
        }
    }

    public static class GSingleToMB
    implements GImageMultiBand {
        GImageSingleBand sb;

        public GSingleToMB(GImageSingleBand sb) {
            this.sb = sb;
        }

        @Override
        public void wrap(ImageBase image) {
            if (this.sb == null) {
                this.sb = FactoryGImageSingleBand.wrap((ImageSingleBand)image);
            } else {
                this.sb.wrap((ImageSingleBand)image);
            }
        }

        @Override
        public int getWidth() {
            return this.sb.getWidth();
        }

        @Override
        public int getHeight() {
            return this.sb.getHeight();
        }

        @Override
        public int getNumberOfBands() {
            return 1;
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.sb.set(x, y, Float.valueOf(value[0]));
        }

        @Override
        public void get(int x, int y, float[] value) {
            value[0] = this.sb.getF(y * this.sb.getWidth() + x);
        }

        @Override
        public void setF(int index, float[] value) {
            this.sb.set(index, value[0]);
        }

        @Override
        public void getF(int index, float[] value) {
            value[0] = this.sb.getF(index);
        }

        @Override
        public float getF(int index) {
            return this.sb.getF(index);
        }

        @Override
        public <T extends ImageBase> T getImage() {
            return (T)this.sb.getImage();
        }
    }

    public static class MS
    implements GImageMultiBand {
        MultiSpectral image;
        GImageSingleBand[] bandWrappers;

        public MS(MultiSpectral image) {
            this.wrap(image);
        }

        public MS() {
        }

        @Override
        public void wrap(ImageBase image) {
            if (this.image == null) {
                this.image = (MultiSpectral)image;
                this.bandWrappers = new GImageSingleBand[this.image.getNumBands()];
                for (int i = 0; i < this.bandWrappers.length; ++i) {
                    this.bandWrappers[i] = FactoryGImageSingleBand.wrap(this.image.getBand(i));
                }
            } else {
                this.image = (MultiSpectral)image;
                for (int i = 0; i < this.bandWrappers.length; ++i) {
                    this.bandWrappers[i].wrap((ImageSingleBand)this.image.getBand(i));
                }
            }
        }

        @Override
        public int getWidth() {
            return this.image.getWidth();
        }

        @Override
        public int getHeight() {
            return this.image.getHeight();
        }

        @Override
        public int getNumberOfBands() {
            return this.image.getNumBands();
        }

        @Override
        public void set(int x, int y, float[] value) {
            int index = this.image.getIndex(x, y);
            this.setF(index, value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            int index = this.image.getIndex(x, y);
            this.getF(index, value);
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < this.image.getNumBands(); ++i) {
                this.bandWrappers[i].set(index, value[i]);
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < this.image.getNumBands(); ++i) {
                value[i] = this.bandWrappers[i].getF(index);
            }
        }

        @Override
        public float getF(int index) {
            throw new RuntimeException("Not supported for MultiSpectral images.  Would be slow.");
        }

        @Override
        public <T extends ImageBase> T getImage() {
            return (T)this.image;
        }
    }
}

