/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.GImageSingleBand;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageSingleBand;

public class GImageSingleBandDistorted<T extends ImageSingleBand>
implements GImageSingleBand {
    PixelTransform_F32 transform;
    InterpolatePixelS<T> interpolate;
    int inputWidth;
    int inputHeight;

    public GImageSingleBandDistorted(PixelTransform_F32 transform, InterpolatePixelS<T> interpolate) {
        this.transform = transform;
        this.interpolate = interpolate;
    }

    @Override
    public void wrap(ImageSingleBand image) {
        this.interpolate.setImage(image);
        this.inputWidth = image.getWidth();
        this.inputHeight = image.getHeight();
    }

    @Override
    public int getWidth() {
        return this.inputWidth;
    }

    @Override
    public int getHeight() {
        return this.inputHeight;
    }

    @Override
    public boolean isFloatingPoint() {
        return true;
    }

    @Override
    public Number get(int x, int y) {
        this.transform.compute(x, y);
        return Float.valueOf(this.interpolate.get(this.transform.distX, this.transform.distY));
    }

    @Override
    public void set(int x, int y, Number num) {
        throw new IllegalArgumentException("set is not supported");
    }

    @Override
    public double unsafe_getD(int x, int y) {
        this.transform.compute(x, y);
        return this.interpolate.get(this.transform.distX, this.transform.distY);
    }

    @Override
    public void set(int index, float value) {
        throw new IllegalArgumentException("set is not supported");
    }

    @Override
    public float getF(int index) {
        throw new IllegalArgumentException("getF is not supported");
    }

    @Override
    public ImageSingleBand getImage() {
        throw new IllegalArgumentException("getImage() is not supported");
    }
}

