/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;

public class ConvertInterleavedToSingle {
    public static void average(InterleavedU8 from, ImageUInt8 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                System.arraycopy(from.data, indexFrom, to.data, indexTo, from.width);
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    int sum = 0;
                    int indexFromEnd = indexFrom + numBands;
                    while (indexFrom < indexFromEnd) {
                        sum += from.data[indexFrom++] & 0xFF;
                    }
                    to.data[indexTo++] = (byte)(sum / numBands);
                }
            }
        }
    }

    public static void average(InterleavedS8 from, ImageSInt8 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                System.arraycopy(from.data, indexFrom, to.data, indexTo, from.width);
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    int sum = 0;
                    int indexFromEnd = indexFrom + numBands;
                    while (indexFrom < indexFromEnd) {
                        sum += from.data[indexFrom++];
                    }
                    to.data[indexTo++] = (byte)(sum / numBands);
                }
            }
        }
    }

    public static void average(InterleavedU16 from, ImageUInt16 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                System.arraycopy(from.data, indexFrom, to.data, indexTo, from.width);
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    int sum = 0;
                    int indexFromEnd = indexFrom + numBands;
                    while (indexFrom < indexFromEnd) {
                        sum += from.data[indexFrom++] & 0xFFFF;
                    }
                    to.data[indexTo++] = (short)(sum / numBands);
                }
            }
        }
    }

    public static void average(InterleavedS16 from, ImageSInt16 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                System.arraycopy(from.data, indexFrom, to.data, indexTo, from.width);
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    int sum = 0;
                    int indexFromEnd = indexFrom + numBands;
                    while (indexFrom < indexFromEnd) {
                        sum += from.data[indexFrom++];
                    }
                    to.data[indexTo++] = (short)(sum / numBands);
                }
            }
        }
    }

    public static void average(InterleavedS32 from, ImageSInt32 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                System.arraycopy(from.data, indexFrom, to.data, indexTo, from.width);
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    int sum = 0;
                    int indexFromEnd = indexFrom + numBands;
                    while (indexFrom < indexFromEnd) {
                        sum += from.data[indexFrom++];
                    }
                    to.data[indexTo++] = sum / numBands;
                }
            }
        }
    }

    public static void average(InterleavedS64 from, ImageSInt64 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                System.arraycopy(from.data, indexFrom, to.data, indexTo, from.width);
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    long sum = 0L;
                    int indexFromEnd = indexFrom + numBands;
                    while (indexFrom < indexFromEnd) {
                        sum += from.data[indexFrom++];
                    }
                    to.data[indexTo++] = sum / (long)numBands;
                }
            }
        }
    }

    public static void average(InterleavedF32 from, ImageFloat32 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                System.arraycopy(from.data, indexFrom, to.data, indexTo, from.width);
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    float sum = 0.0f;
                    int indexFromEnd = indexFrom + numBands;
                    while (indexFrom < indexFromEnd) {
                        sum += from.data[indexFrom++];
                    }
                    to.data[indexTo++] = sum / (float)numBands;
                }
            }
        }
    }

    public static void average(InterleavedF64 from, ImageFloat64 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                System.arraycopy(from.data, indexFrom, to.data, indexTo, from.width);
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    double sum = 0.0;
                    int indexFromEnd = indexFrom + numBands;
                    while (indexFrom < indexFromEnd) {
                        sum += from.data[indexFrom++];
                    }
                    to.data[indexTo++] = sum / (double)numBands;
                }
            }
        }
    }
}

