/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.inst;

import boofcv.core.image.ImageGenerator;
import boofcv.core.image.inst.SingleBandGenerator;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import java.lang.reflect.Array;

public class FactoryImageGenerator {
    public static <T extends ImageSingleBand> ImageGenerator<T> create(Class<T> type) {
        return new SingleBandGenerator<T>(type);
    }

    public static <T extends ImageSingleBand> ImageGenerator<T> create(T original) {
        return new WrapImage<T>(original);
    }

    public static class WrapImage<T extends ImageSingleBand>
    implements ImageGenerator<T> {
        T original;

        public WrapImage(T original) {
            this.original = original;
        }

        @Override
        public T[] createArray(int number) {
            return (ImageSingleBand[])Array.newInstance(this.original.getClass(), number);
        }

        @Override
        public T createInstance(int width, int height) {
            return (T)((ImageSingleBand)((ImageBase)this.original)._createNew(width, height));
        }

        @Override
        public Class<T> getType() {
            return this.original.getClass();
        }
    }
}

