/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.interpolate;

import boofcv.abst.filter.interpolate.InterpolatePixel_MS_using_SB;
import boofcv.alg.interpolate.BilinearPixelMB;
import boofcv.alg.interpolate.BilinearPixelS;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolatePixel_S_to_MB;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.interpolate.NearestNeighborPixelMB;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.interpolate.impl.BilinearRectangle_F32;
import boofcv.alg.interpolate.impl.BilinearRectangle_S16;
import boofcv.alg.interpolate.impl.BilinearRectangle_U8;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_F32;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_F64;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_IL_F32;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_IL_F64;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_IL_S16;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_IL_S32;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_IL_U8;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_S16;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_S32;
import boofcv.alg.interpolate.impl.ImplBilinearPixel_U8;
import boofcv.alg.interpolate.impl.ImplInterpolatePixelConvolution_F32;
import boofcv.alg.interpolate.impl.ImplInterpolatePixelConvolution_S16;
import boofcv.alg.interpolate.impl.ImplInterpolatePixelConvolution_U8;
import boofcv.alg.interpolate.impl.ImplPolynomialPixel_F32;
import boofcv.alg.interpolate.impl.ImplPolynomialPixel_I;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_F32;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_IL_F32;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_IL_S16;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_IL_S32;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_IL_U8;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_S16;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_S32;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_U16;
import boofcv.alg.interpolate.impl.NearestNeighborPixel_U8;
import boofcv.alg.interpolate.impl.NearestNeighborRectangle_F32;
import boofcv.alg.interpolate.kernel.BicubicKernel_F32;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class FactoryInterpolation {
    public static <T extends ImageSingleBand> InterpolatePixelS<T> createPixelS(double min, double max, TypeInterpolate type, BorderType borderType, ImageDataType dataType) {
        Class t = ImageDataType.typeToSingleClass(dataType);
        return FactoryInterpolation.createPixelS(min, max, type, borderType, t);
    }

    public static <T extends ImageBase> InterpolatePixel<T> createPixel(double min, double max, TypeInterpolate type, BorderType borderType, ImageType<T> imageType) {
        switch (imageType.getFamily()) {
            case SINGLE_BAND: 
            case MULTI_SPECTRAL: {
                return FactoryInterpolation.createPixelS(min, max, type, borderType, imageType.getImageClass());
            }
            case INTERLEAVED: {
                return FactoryInterpolation.createPixelMB(min, max, type, borderType, imageType);
            }
        }
        throw new IllegalArgumentException("Unknown family");
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> createPixelS(double min, double max, TypeInterpolate type, BorderType borderType, Class<T> imageType) {
        InterpolatePixelS<T> alg;
        switch (type) {
            case NEAREST_NEIGHBOR: {
                alg = FactoryInterpolation.nearestNeighborPixelS(imageType);
                break;
            }
            case BILINEAR: {
                return FactoryInterpolation.bilinearPixelS(imageType, borderType);
            }
            case BICUBIC: {
                alg = FactoryInterpolation.bicubicS(-0.5f, (float)min, (float)max, imageType);
                break;
            }
            case POLYNOMIAL4: {
                alg = FactoryInterpolation.polynomialS(4, min, max, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Add type: " + (Object)((Object)type));
            }
        }
        if (borderType != null) {
            alg.setBorder(FactoryImageBorder.single(imageType, borderType));
        }
        return alg;
    }

    public static <T extends ImageBase> InterpolatePixelMB<T> createPixelMB(double min, double max, TypeInterpolate type, BorderType borderType, ImageType<T> imageType) {
        switch (imageType.getFamily()) {
            case MULTI_SPECTRAL: {
                return FactoryInterpolation.createPixelMS(FactoryInterpolation.createPixelS(min, max, type, borderType, imageType.getDataType()));
            }
            case SINGLE_BAND: {
                InterpolatePixelS<T> interpS = FactoryInterpolation.createPixelS(min, max, type, borderType, imageType.getImageClass());
                return new InterpolatePixel_S_to_MB<T>(interpS);
            }
            case INTERLEAVED: {
                switch (type) {
                    case NEAREST_NEIGHBOR: {
                        return FactoryInterpolation.nearestNeighborPixelMB(imageType, borderType);
                    }
                    case BILINEAR: {
                        return FactoryInterpolation.bilinearPixelMB(imageType, borderType);
                    }
                }
                throw new IllegalArgumentException("Interpolate type not yet support for ImageInterleaved");
            }
        }
        throw new IllegalArgumentException("Add type: " + (Object)((Object)type));
    }

    public static <T extends ImageSingleBand> InterpolatePixelMB<MultiSpectral<T>> createPixelMS(InterpolatePixelS<T> singleBand) {
        return new InterpolatePixel_MS_using_SB<T>(singleBand);
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> bilinearPixelS(T image, BorderType borderType) {
        InterpolatePixelS<?> ret = FactoryInterpolation.bilinearPixelS(image.getClass(), borderType);
        ret.setImage(image);
        return ret;
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> bilinearPixelS(Class<T> imageType, BorderType borderType) {
        BilinearPixelS alg;
        if (imageType == ImageFloat32.class) {
            alg = new ImplBilinearPixel_F32();
        } else if (imageType == ImageFloat64.class) {
            alg = new ImplBilinearPixel_F64();
        } else if (imageType == ImageUInt8.class) {
            alg = new ImplBilinearPixel_U8();
        } else if (imageType == ImageSInt16.class) {
            alg = new ImplBilinearPixel_S16();
        } else if (imageType == ImageSInt32.class) {
            alg = new ImplBilinearPixel_S32();
        } else {
            throw new RuntimeException("Unknown image type: " + FactoryInterpolation.typeName(imageType));
        }
        if (borderType != null) {
            alg.setBorder(FactoryImageBorder.single(imageType, borderType));
        }
        return alg;
    }

    public static <T extends ImageMultiBand> InterpolatePixelMB<T> bilinearPixelMB(T image, BorderType borderType) {
        InterpolatePixelMB<T> ret = FactoryInterpolation.bilinearPixelMB(image.getImageType(), borderType);
        ret.setImage(image);
        return ret;
    }

    public static <T extends ImageMultiBand> InterpolatePixelMB<T> bilinearPixelMB(ImageType<T> imageType, BorderType borderType) {
        BilinearPixelMB alg;
        int numBands = imageType.getNumBands();
        if (imageType.getFamily() == ImageType.Family.INTERLEAVED) {
            switch (imageType.getDataType()) {
                case U8: {
                    alg = new ImplBilinearPixel_IL_U8(numBands);
                    break;
                }
                case S16: {
                    alg = new ImplBilinearPixel_IL_S16(numBands);
                    break;
                }
                case S32: {
                    alg = new ImplBilinearPixel_IL_S32(numBands);
                    break;
                }
                case F32: {
                    alg = new ImplBilinearPixel_IL_F32(numBands);
                    break;
                }
                case F64: {
                    alg = new ImplBilinearPixel_IL_F64(numBands);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Add support");
                }
            }
            if (borderType != null) {
                alg.setBorder(FactoryImageBorder.interleaved(imageType.getImageClass(), borderType));
            }
        } else {
            throw new IllegalArgumentException("Only interleaved current supported here");
        }
        return alg;
    }

    public static <T extends ImageMultiBand> InterpolatePixelMB<T> nearestNeighborPixelMB(ImageType<T> imageType, BorderType borderType) {
        NearestNeighborPixelMB alg;
        if (imageType.getFamily() == ImageType.Family.INTERLEAVED) {
            switch (imageType.getDataType()) {
                case U8: {
                    alg = new NearestNeighborPixel_IL_U8();
                    break;
                }
                case S16: {
                    alg = new NearestNeighborPixel_IL_S16();
                    break;
                }
                case S32: {
                    alg = new NearestNeighborPixel_IL_S32();
                    break;
                }
                case F32: {
                    alg = new NearestNeighborPixel_IL_F32();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Add support");
                }
            }
            if (borderType != null) {
                alg.setBorder(FactoryImageBorder.interleaved(imageType.getImageClass(), borderType));
            }
        } else {
            throw new IllegalArgumentException("Only interleaved current supported here");
        }
        return alg;
    }

    private static String typeName(Class type) {
        return type == null ? "null" : type.getName();
    }

    public static <T extends ImageSingleBand> InterpolateRectangle<T> bilinearRectangle(T image) {
        InterpolateRectangle<?> ret = FactoryInterpolation.bilinearRectangle(image.getClass());
        ret.setImage(image);
        return ret;
    }

    public static <T extends ImageSingleBand> InterpolateRectangle<T> bilinearRectangle(Class<T> type) {
        if (type == ImageFloat32.class) {
            return new BilinearRectangle_F32();
        }
        if (type == ImageUInt8.class) {
            return new BilinearRectangle_U8();
        }
        if (type == ImageSInt16.class) {
            return new BilinearRectangle_S16();
        }
        throw new RuntimeException("Unknown image type: " + FactoryInterpolation.typeName(type));
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> nearestNeighborPixelS(Class<T> type) {
        if (type == ImageFloat32.class) {
            return new NearestNeighborPixel_F32();
        }
        if (type == ImageUInt8.class) {
            return new NearestNeighborPixel_U8();
        }
        if (type == ImageSInt16.class) {
            return new NearestNeighborPixel_S16();
        }
        if (type == ImageUInt16.class) {
            return new NearestNeighborPixel_U16();
        }
        if (type == ImageSInt32.class) {
            return new NearestNeighborPixel_S32();
        }
        throw new RuntimeException("Unknown image type: " + FactoryInterpolation.typeName(type));
    }

    public static <T extends ImageSingleBand> InterpolateRectangle<T> nearestNeighborRectangle(Class<?> type) {
        if (type == ImageFloat32.class) {
            return new NearestNeighborRectangle_F32();
        }
        throw new RuntimeException("Unknown image type: " + FactoryInterpolation.typeName(type));
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> bicubicS(float param, float min, float max, Class<T> type) {
        BicubicKernel_F32 kernel = new BicubicKernel_F32(param);
        if (type == ImageFloat32.class) {
            return new ImplInterpolatePixelConvolution_F32(kernel, min, max);
        }
        if (type == ImageUInt8.class) {
            return new ImplInterpolatePixelConvolution_U8(kernel, min, max);
        }
        if (type == ImageSInt16.class) {
            return new ImplInterpolatePixelConvolution_S16(kernel, min, max);
        }
        throw new RuntimeException("Unknown image type: " + FactoryInterpolation.typeName(type));
    }

    public static <T extends ImageSingleBand> InterpolatePixelS<T> polynomialS(int maxDegree, double min, double max, Class<T> type) {
        if (type == ImageFloat32.class) {
            return new ImplPolynomialPixel_F32(maxDegree, (float)min, (float)max);
        }
        if (ImageInteger.class.isAssignableFrom(type)) {
            return new ImplPolynomialPixel_I(maxDegree, (float)min, (float)max);
        }
        throw new RuntimeException("Unknown image type: " + FactoryInterpolation.typeName(type));
    }
}

