/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.InterleavedI16;

public class InterleavedU16
extends InterleavedI16<InterleavedU16> {
    public InterleavedU16(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public InterleavedU16() {
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.U16;
    }

    @Override
    public void get_unsafe(int x, int y, int[] storage) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index] & 0xFFFF;
            ++i;
            ++index;
        }
    }

    @Override
    public int getBand(int x, int y, int band) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        return this.data[this.getIndex(x, y, band)] & 0xFFFF;
    }

    @Override
    public InterleavedU16 _createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new InterleavedU16();
        }
        return new InterleavedU16(imgWidth, imgHeight, this.numBands);
    }
}

