/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.impl.DistortSupport;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.distort.PointTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.affine.Affine2D_F64;

public class FDistort {
    ImageType inputType;
    ImageBase input;
    ImageBase output;
    ImageDistort distorter;
    InterpolatePixel interp;
    PixelTransform_F32 outputToInput;
    boolean cached;

    public FDistort(ImageBase input, ImageBase output) {
        this.init(input, output);
    }

    public FDistort(ImageType inputType) {
        this.inputType = inputType;
    }

    public FDistort() {
    }

    public FDistort init(ImageBase input, ImageBase output) {
        this.input = input;
        this.output = output;
        this.inputType = input.getImageType();
        this.interp(TypeInterpolate.BILINEAR);
        this.border(0.0);
        this.cached = false;
        this.distorter = null;
        this.outputToInput = null;
        return this;
    }

    public FDistort input(ImageBase input) {
        if (this.input == null || this.input.width != input.width || this.input.height != input.height) {
            this.distorter = null;
        }
        this.input = input;
        this.inputType = input.getImageType();
        return this;
    }

    public FDistort output(ImageBase output) {
        if (this.output == null || this.output.width != output.width || this.output.height != output.height) {
            this.distorter = null;
        }
        this.output = output;
        return this;
    }

    public FDistort border(ImageBorder border) {
        this.distorter = null;
        this.interp.setBorder(border);
        return this;
    }

    public FDistort border(BorderType type) {
        return this.border(FactoryImageBorder.generic(type, this.inputType));
    }

    public FDistort border(double value) {
        return this.border(FactoryImageBorder.genericValue(value, this.inputType));
    }

    public FDistort borderExt() {
        return this.border(BorderType.EXTENDED);
    }

    public FDistort interp(InterpolatePixelS interpolation) {
        this.distorter = null;
        this.interp = interpolation;
        return this;
    }

    public FDistort interp(TypeInterpolate type) {
        this.distorter = null;
        this.interp = FactoryInterpolation.createPixel(0.0, 255.0, type, BorderType.EXTENDED, this.inputType);
        return this;
    }

    public FDistort interpNN() {
        return this.interp(TypeInterpolate.NEAREST_NEIGHBOR);
    }

    public FDistort cached(boolean cached) {
        this.distorter = null;
        this.cached = cached;
        return this;
    }

    public FDistort transform(PixelTransform_F32 outputToInput) {
        this.outputToInput = outputToInput;
        return this;
    }

    public FDistort transform(PointTransform_F32 outputToInput) {
        return this.transform(new PointToPixelTransform_F32(outputToInput));
    }

    public FDistort affine(double a11, double a12, double a21, double a22, double dx, double dy) {
        Affine2D_F32 m = new Affine2D_F32();
        m.a11 = (float)a11;
        m.a12 = (float)a12;
        m.a21 = (float)a21;
        m.a22 = (float)a22;
        m.tx = (float)dx;
        m.ty = (float)dy;
        m = m.invert(null);
        return this.transform(new PixelTransformAffine_F32(m));
    }

    public FDistort affine(Affine2D_F64 affine) {
        return this.affine(affine.a11, affine.a12, affine.a21, affine.a22, affine.tx, affine.ty);
    }

    public FDistort scale() {
        return this.transform(DistortSupport.transformScale(this.output, this.input));
    }

    public FDistort scaleExt() {
        return this.scale().borderExt();
    }

    public FDistort rotate(double angleInputToOutput) {
        PixelTransformAffine_F32 outputToInput = DistortSupport.transformRotate(this.input.width / 2, this.input.height / 2, this.output.width / 2, this.output.height / 2, (float)angleInputToOutput);
        return this.transform(outputToInput);
    }

    public void apply() {
        if (this.distorter == null) {
            Class typeOut = this.output.getImageType().getImageClass();
            switch (this.input.getImageType().getFamily()) {
                case SINGLE_BAND: {
                    this.distorter = FactoryDistort.distortSB(this.cached, (InterpolatePixelS)this.interp, typeOut);
                    break;
                }
                case MULTI_SPECTRAL: {
                    this.distorter = FactoryDistort.distortMS(this.cached, (InterpolatePixelS)this.interp, typeOut);
                    break;
                }
                case INTERLEAVED: {
                    this.distorter = FactoryDistort.distortIL(this.cached, (InterpolatePixelMB)this.interp, this.output.getImageType());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type");
                }
            }
        }
        this.distorter.setModel(this.outputToInput);
        this.distorter.apply(this.input, this.output);
    }
}

