/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.impl;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.impl.ImplImageDistort_MS;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.factory.distort.FactoryDistort;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.MultiSpectral;
import georegression.struct.InvertibleTransform;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.se.Se2_F32;
import georegression.transform.ConvertTransform_F32;
import georegression.transform.InvertibleTransformSequence;

public class DistortSupport {
    public static PixelTransformAffine_F32 transformScale(ImageBase from, ImageBase to) {
        float scaleX = (float)to.width / (float)from.width;
        float scaleY = (float)to.height / (float)from.height;
        Affine2D_F32 affine = new Affine2D_F32(scaleX, 0.0f, 0.0f, scaleY, 0.0f, 0.0f);
        PixelTransformAffine_F32 distort = new PixelTransformAffine_F32();
        distort.set(affine);
        return distort;
    }

    public static PixelTransformAffine_F32 transformRotate(float x0, float y0, float x1, float y1, float angle) {
        Se2_F32 imageToCenter = new Se2_F32(-x0, -y0, 0.0f);
        Se2_F32 rotate = new Se2_F32(0.0f, 0.0f, angle);
        Se2_F32 centerToImage = new Se2_F32(x1, y1, 0.0f);
        InvertibleTransformSequence sequence = new InvertibleTransformSequence();
        sequence.addTransform(true, (InvertibleTransform)imageToCenter);
        sequence.addTransform(true, (InvertibleTransform)rotate);
        sequence.addTransform(true, (InvertibleTransform)centerToImage);
        Se2_F32 total = new Se2_F32();
        sequence.computeTransform((InvertibleTransform)total);
        Se2_F32 inv = total.invert(null);
        Affine2D_F32 affine = ConvertTransform_F32.convert((Se2_F32)inv, (Affine2D_F32)null);
        PixelTransformAffine_F32 distort = new PixelTransformAffine_F32();
        distort.set(affine);
        return distort;
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> ImageDistort<MultiSpectral<Input>, MultiSpectral<Output>> createDistortMS(Class<Output> outputType, PixelTransform_F32 dstToSrc, InterpolatePixelS<Input> interp, boolean cached) {
        ImageDistort<Input, Output> bandDistort = FactoryDistort.distortSB(cached, interp, outputType);
        bandDistort.setModel(dstToSrc);
        return new ImplImageDistort_MS<Input, Output>(bandDistort);
    }
}

