/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.sparse.GradientValue_I32;
import boofcv.struct.sparse.SparseImageGradient;

public class GradientSparseTwo1_U8
implements SparseImageGradient<ImageUInt8, GradientValue_I32> {
    ImageUInt8 input;
    ImageBorder_S32<ImageUInt8> border;
    GradientValue_I32 gradient = new GradientValue_I32();

    public GradientSparseTwo1_U8(ImageBorder_S32<ImageUInt8> border) {
        this.border = border;
    }

    @Override
    public GradientValue_I32 compute(int x, int y) {
        int a10;
        int a01;
        int a11;
        if (x > 0 && y > 0 && x < this.input.width && y < this.input.height) {
            int s = this.input.stride;
            int br = this.input.startIndex + s * y + x;
            a11 = this.input.data[br] & 0xFF;
            a01 = this.input.data[br - s] & 0xFF;
            a10 = this.input.data[br - 1] & 0xFF;
        } else {
            a11 = this.border.get(x, y);
            a01 = this.border.get(x, y - 1);
            a10 = this.border.get(x - 1, y);
        }
        this.gradient.y = a11 - a01;
        this.gradient.x = a11 - a10;
        return this.gradient;
    }

    @Override
    public Class<GradientValue_I32> getGradientType() {
        return GradientValue_I32.class;
    }

    @Override
    public void setImage(ImageUInt8 input) {
        this.input = input;
        if (this.border != null) {
            this.border.setImage(input);
        }
    }

    @Override
    public boolean isInBounds(int x, int y) {
        return this.border != null || x > 0 && y > 0 && x < this.input.width && y < this.input.height;
    }
}

