/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.factory.filter.convolve.FactoryConvolve;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.BoofDefaults;
import boofcv.struct.gss.GaussianScaleSpace;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;

public class NoCacheScaleSpace<I extends ImageSingleBand, D extends ImageSingleBand>
implements GaussianScaleSpace<I, D> {
    private I originalImage;
    private Class<I> inputType;
    AnyImageDerivative<I, D> anyDeriv;
    private double[] scales;
    private int currentScale;
    private I workImage;
    private I scaledImage;
    BorderType borderDeriv = BoofDefaults.DERIV_BORDER_TYPE;
    BorderType borderBlur = BorderType.NORMALIZED;

    public NoCacheScaleSpace(Class<I> inputType, Class<D> derivType) {
        this.inputType = inputType;
        this.anyDeriv = GImageDerivativeOps.derivativeForScaleSpace(inputType, derivType);
    }

    @Override
    public void setScales(double ... scales) {
        this.scales = scales;
    }

    @Override
    public double getScale(int level) {
        return this.scales[level];
    }

    @Override
    public void setImage(I input) {
        this.originalImage = input;
        if (this.scaledImage == null) {
            this.scaledImage = GeneralizedImageOps.createSingleBand(this.inputType, ((ImageBase)input).getWidth(), ((ImageBase)input).getHeight());
            this.workImage = GeneralizedImageOps.createSingleBand(this.inputType, ((ImageBase)input).getWidth(), ((ImageBase)input).getHeight());
        } else if (((ImageSingleBand)this.scaledImage).width != ((ImageSingleBand)input).width || ((ImageSingleBand)this.scaledImage).height != ((ImageSingleBand)input).height) {
            ((ImageSingleBand)this.scaledImage).reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
            ((ImageSingleBand)this.workImage).reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        }
    }

    @Override
    public void setActiveScale(int index) {
        this.currentScale = index;
        double sigma = this.scales[index];
        int radius = FactoryKernelGaussian.radiusForSigma(sigma, 0);
        Object kernel = FactoryKernelGaussian.gaussian1D(this.inputType, sigma, radius);
        ConvolveInterface<I, I> blurX = FactoryConvolve.convolve(kernel, this.inputType, this.inputType, this.borderBlur, true);
        ConvolveInterface<I, I> blurY = FactoryConvolve.convolve(kernel, this.inputType, this.inputType, this.borderBlur, false);
        blurX.process(this.originalImage, this.workImage);
        blurY.process(this.workImage, this.scaledImage);
        this.anyDeriv.setInput(this.scaledImage);
    }

    @Override
    public double getCurrentScale() {
        return this.scales[this.currentScale];
    }

    @Override
    public int getTotalScales() {
        return this.scales.length;
    }

    @Override
    public I getScaledImage() {
        return this.scaledImage;
    }

    @Override
    public void setBorderType(BorderType type) {
        this.borderDeriv = type;
        this.borderBlur = type;
        this.setActiveScale(this.currentScale);
    }

    @Override
    public BorderType getBorderType() {
        return this.borderDeriv;
    }

    @Override
    public D getDerivative(boolean ... isX) {
        return this.anyDeriv.getDerivative(isX);
    }
}

