/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.border;

import boofcv.core.image.border.BorderIndex1D_Extend;
import boofcv.core.image.border.BorderIndex1D_Reflect;
import boofcv.core.image.border.BorderIndex1D_Wrap;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder1D_F32;
import boofcv.core.image.border.ImageBorder1D_F64;
import boofcv.core.image.border.ImageBorder1D_IL_F32;
import boofcv.core.image.border.ImageBorder1D_IL_F64;
import boofcv.core.image.border.ImageBorder1D_IL_S32;
import boofcv.core.image.border.ImageBorder1D_IL_S64;
import boofcv.core.image.border.ImageBorder1D_S32;
import boofcv.core.image.border.ImageBorder1D_S64;
import boofcv.core.image.border.ImageBorderValue;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedInteger;
import boofcv.struct.image.InterleavedS64;

public class FactoryImageBorder {
    public static <T extends ImageSingleBand> ImageBorder<T> single(T image, BorderType borderType) {
        ImageBorder<?> ret = FactoryImageBorder.single(image.getClass(), borderType);
        ret.setImage(image);
        return ret;
    }

    public static <T extends ImageInterleaved> ImageBorder<T> interleaved(T image, BorderType borderType) {
        ImageBorder<?> ret = FactoryImageBorder.interleaved(image.getClass(), borderType);
        ret.setImage(image);
        return ret;
    }

    public static Class<ImageBorder> lookupBorderClassType(Class<ImageSingleBand> imageType) {
        if (imageType == ImageFloat32.class) {
            return ImageBorder1D_F32.class;
        }
        if (imageType == ImageFloat64.class) {
            return ImageBorder1D_F64.class;
        }
        if (ImageInteger.class.isAssignableFrom(imageType)) {
            return ImageBorder1D_S32.class;
        }
        if (imageType == ImageSInt64.class) {
            return ImageBorder1D_S64.class;
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <T extends ImageBase> ImageBorder<T> generic(BorderType borderType, ImageType<T> imageType) {
        switch (imageType.getFamily()) {
            case SINGLE_BAND: {
                return FactoryImageBorder.single(imageType.getImageClass(), borderType);
            }
            case MULTI_SPECTRAL: {
                return FactoryImageBorder.single(imageType.getImageClass(), borderType);
            }
            case INTERLEAVED: {
                return FactoryImageBorder.interleaved(imageType.getImageClass(), borderType);
            }
        }
        throw new IllegalArgumentException("Unknown family");
    }

    public static <T extends ImageBase> ImageBorder<T> genericValue(double value, ImageType<T> imageType) {
        switch (imageType.getFamily()) {
            case SINGLE_BAND: {
                return FactoryImageBorder.singleValue(imageType.getImageClass(), value);
            }
            case MULTI_SPECTRAL: {
                return FactoryImageBorder.singleValue(imageType.getImageClass(), value);
            }
            case INTERLEAVED: {
                return FactoryImageBorder.interleavedValue(imageType.getImageClass(), value);
            }
        }
        throw new IllegalArgumentException("Unknown family");
    }

    public static <T extends ImageSingleBand> ImageBorder<T> single(Class<T> imageType, BorderType borderType) {
        Class borderClass;
        switch (borderType) {
            case SKIP: {
                throw new IllegalArgumentException("Skip border can't be implemented here and has to be done externally.  Call this might be a bug. Instead pass in EXTENDED and manually skip over the pixel in a loop some place.");
            }
            case NORMALIZED: {
                throw new IllegalArgumentException("Normalized can't be supported by this border interface");
            }
            case REFLECT: {
                borderClass = BorderIndex1D_Reflect.class;
                break;
            }
            case EXTENDED: {
                borderClass = BorderIndex1D_Extend.class;
                break;
            }
            case WRAP: {
                borderClass = BorderIndex1D_Wrap.class;
                break;
            }
            case VALUE: {
                return FactoryImageBorder.singleValue(imageType, 0.0);
            }
            default: {
                throw new IllegalArgumentException("Border type not supported: " + (Object)((Object)borderType));
            }
        }
        if (imageType == ImageFloat32.class) {
            return new ImageBorder1D_F32(borderClass);
        }
        if (imageType == ImageFloat64.class) {
            return new ImageBorder1D_F64(borderClass);
        }
        if (ImageInteger.class.isAssignableFrom(imageType)) {
            return new ImageBorder1D_S32(borderClass);
        }
        if (imageType == ImageSInt64.class) {
            return new ImageBorder1D_S64(borderClass);
        }
        throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageInterleaved> ImageBorder<T> interleaved(Class<T> imageType, BorderType borderType) {
        Class borderClass;
        switch (borderType) {
            case SKIP: {
                throw new IllegalArgumentException("Skip border can't be implemented here and has to be done externally.  Call this might be a bug. Instead pass in EXTENDED and manually skip over the pixel in a loop some place.");
            }
            case NORMALIZED: {
                throw new IllegalArgumentException("Normalized can't be supported by this border interface");
            }
            case REFLECT: {
                borderClass = BorderIndex1D_Reflect.class;
                break;
            }
            case EXTENDED: {
                borderClass = BorderIndex1D_Extend.class;
                break;
            }
            case WRAP: {
                borderClass = BorderIndex1D_Wrap.class;
                break;
            }
            case VALUE: {
                return FactoryImageBorder.interleavedValue(imageType, 0.0);
            }
            default: {
                throw new IllegalArgumentException("Border type not supported: " + (Object)((Object)borderType));
            }
        }
        if (imageType == InterleavedF32.class) {
            return new ImageBorder1D_IL_F32(borderClass);
        }
        if (imageType == InterleavedF64.class) {
            return new ImageBorder1D_IL_F64(borderClass);
        }
        if (InterleavedInteger.class.isAssignableFrom(imageType)) {
            return new ImageBorder1D_IL_S32(borderClass);
        }
        if (imageType == InterleavedS64.class) {
            return new ImageBorder1D_IL_S64(borderClass);
        }
        throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageSingleBand> ImageBorder<T> singleValue(T image, double value) {
        ImageBorder<?> border = FactoryImageBorder.singleValue(image.getClass(), value);
        border.setImage(image);
        return border;
    }

    public static <T extends ImageSingleBand> ImageBorder<T> singleValue(Class<T> imageType, double value) {
        if (imageType == ImageFloat32.class) {
            return new ImageBorderValue.Value_F32((float)value);
        }
        if (imageType == ImageFloat64.class) {
            return new ImageBorderValue.Value_F64(value);
        }
        if (ImageInteger.class.isAssignableFrom(imageType)) {
            return new ImageBorderValue.Value_I((int)value);
        }
        throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageInterleaved> ImageBorder<T> interleavedValue(T image, double value) {
        ImageBorder<?> border = FactoryImageBorder.interleavedValue(image.getClass(), value);
        border.setImage(image);
        return border;
    }

    public static <T extends ImageInterleaved> ImageBorder<T> interleavedValue(Class<T> imageType, double value) {
        if (imageType == InterleavedF32.class) {
            return new ImageBorderValue.Value_IL_F32((float)value);
        }
        if (imageType == InterleavedF64.class) {
            return new ImageBorderValue.Value_IL_F64(value);
        }
        if (InterleavedInteger.class.isAssignableFrom(imageType)) {
            return new ImageBorderValue.Value_IL_S32((int)value);
        }
        if (imageType == InterleavedS64.class) {
            return new ImageBorderValue.Value_IL_S64((long)value);
        }
        throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
    }
}

