/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import java.lang.reflect.Array;

public abstract class ImageInterleaved<T extends ImageInterleaved>
extends ImageMultiBand<T> {
    public int numBands;

    protected ImageInterleaved(int width, int height, int numBands) {
        this._setData(Array.newInstance(this.getPrimitiveDataType(), width * height * numBands));
        this.startIndex = 0;
        this.stride = width * numBands;
        this.numBands = numBands;
        this.width = width;
        this.height = height;
        this.imageType = ImageType.il(numBands, this.getClass());
    }

    protected ImageInterleaved() {
    }

    @Override
    public T subimage(int x0, int y0, int x1, int y1, T subimage) {
        ImageInterleaved ret = (ImageInterleaved)this._createNew(-1, -1);
        ret._setData(this._getData());
        ret.stride = Math.max(this.width * this.numBands, this.stride);
        ret.width = x1 - x0;
        ret.height = y1 - y0;
        ret.numBands = this.numBands;
        ret.startIndex = this.startIndex + y0 * this.stride + x0 * this.numBands;
        ret.subImage = true;
        ret.imageType = this.imageType;
        return (T)ret;
    }

    @Override
    public void reshape(int width, int height) {
        if (this.isSubimage()) {
            throw new IllegalArgumentException("Can't reshape sub-images");
        }
        Object data = this._getData();
        if (Array.getLength(data) < width * height * this.numBands) {
            ImageInterleaved a = (ImageInterleaved)this._createNew(width, height);
            this._setData(a._getData());
        }
        this.width = width;
        this.height = height;
        this.stride = width * this.numBands;
    }

    @Override
    public int getIndex(int x, int y) {
        return this.startIndex + y * this.stride + x * this.numBands;
    }

    public int getIndex(int x, int y, int band) {
        return this.startIndex + y * this.stride + x * this.numBands + band;
    }

    @Override
    public void setTo(T orig) {
        if (((ImageInterleaved)orig).width != this.width || ((ImageInterleaved)orig).height != this.height) {
            this.reshape(((ImageInterleaved)orig).width, ((ImageInterleaved)orig).height);
        }
        if (((ImageInterleaved)orig).numBands != this.numBands) {
            throw new IllegalArgumentException("The two images have different number of bands");
        }
        if (!((ImageBase)orig).isSubimage() && !this.isSubimage()) {
            System.arraycopy(((ImageInterleaved)orig)._getData(), ((ImageInterleaved)orig).startIndex, this._getData(), this.startIndex, this.stride * this.height);
        } else {
            int indexSrc = ((ImageInterleaved)orig).startIndex;
            int indexDst = this.startIndex;
            for (int y = 0; y < this.height; ++y) {
                System.arraycopy(((ImageInterleaved)orig)._getData(), indexSrc, this._getData(), indexDst, this.width * this.numBands);
                indexSrc += ((ImageInterleaved)orig).stride;
                indexDst += this.stride;
            }
        }
    }

    @Override
    public int getNumBands() {
        return this.numBands;
    }

    public final void setNumBands(int numBands) {
        this.numBands = numBands;
    }

    public abstract ImageDataType getDataType();

    protected abstract Object _getData();

    protected abstract Class getPrimitiveDataType();

    protected abstract void _setData(Object var1);
}

