/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class ThresholdImageOps {
    public static ImageUInt8 threshold(ImageFloat32 input, ImageUInt8 output, float threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] > threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 threshold(ImageFloat64 input, ImageUInt8 output, double threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] > threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 threshold(ImageUInt8 input, ImageUInt8 output, int threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = (input.data[indexIn] & 0xFF) <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = (input.data[indexIn] & 0xFF) > threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 threshold(ImageSInt16 input, ImageUInt8 output, int threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] > threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 threshold(ImageUInt16 input, ImageUInt8 output, int threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = (input.data[indexIn] & 0xFFFF) <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = (input.data[indexIn] & 0xFFFF) > threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 threshold(ImageSInt32 input, ImageUInt8 output, int threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] > threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 localSquare(ImageUInt8 input, ImageUInt8 output, int radius, float scale, boolean down, ImageUInt8 storage1, ImageUInt8 storage2) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        storage1 = InputSanityCheck.checkDeclare(input, storage1, ImageUInt8.class);
        storage2 = InputSanityCheck.checkDeclare(input, storage2, ImageUInt8.class);
        ImageUInt8 mean = storage1;
        BlurImageOps.mean(input, mean, radius, storage2);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = mean.startIndex + y * mean.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = (float)(mean.data[indexMean] & 0xFF) * scale;
                    output.data[indexOut] = (float)(input.data[indexIn] & 0xFF) <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = mean.startIndex + y * mean.stride;
                int end = indexIn + input.width;
                int x = 0;
                while (indexIn < end) {
                    int threshold = mean.data[indexMean] & 0xFF;
                    output.data[indexOut] = (float)(input.data[indexIn] & 0xFF) * scale > (float)threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                    ++x;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 localGaussian(ImageUInt8 input, ImageUInt8 output, int radius, float scale, boolean down, ImageUInt8 storage1, ImageUInt8 storage2) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        storage1 = InputSanityCheck.checkDeclare(input, storage1, ImageUInt8.class);
        storage2 = InputSanityCheck.checkDeclare(input, storage2, ImageUInt8.class);
        ImageUInt8 blur = storage1;
        BlurImageOps.gaussian(input, blur, -1.0, radius, storage2);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = blur.startIndex + y * blur.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = (float)(blur.data[indexMean] & 0xFF) * scale;
                    output.data[indexOut] = (float)(input.data[indexIn] & 0xFF) <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = blur.startIndex + y * blur.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    int threshold = blur.data[indexMean] & 0xFF;
                    output.data[indexOut] = (float)(input.data[indexIn] & 0xFF) * scale > (float)threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 localSquare(ImageFloat32 input, ImageUInt8 output, int radius, float scale, boolean down, ImageFloat32 storage1, ImageFloat32 storage2) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        storage1 = InputSanityCheck.checkDeclare(input, storage1, ImageFloat32.class);
        storage2 = InputSanityCheck.checkDeclare(input, storage2, ImageFloat32.class);
        ImageFloat32 mean = storage1;
        BlurImageOps.mean(input, mean, radius, storage2);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = mean.startIndex + y * mean.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = mean.data[indexMean] * scale;
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = mean.startIndex + y * mean.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = mean.data[indexMean];
                    output.data[indexOut] = input.data[indexIn] * scale > threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 localGaussian(ImageFloat32 input, ImageUInt8 output, int radius, float scale, boolean down, ImageFloat32 storage1, ImageFloat32 storage2) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        storage1 = InputSanityCheck.checkDeclare(input, storage1, ImageFloat32.class);
        storage2 = InputSanityCheck.checkDeclare(input, storage2, ImageFloat32.class);
        ImageFloat32 blur = storage1;
        BlurImageOps.gaussian(input, blur, -1.0, radius, storage2);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = blur.startIndex + y * blur.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = blur.data[indexMean] * scale;
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int indexMean = blur.startIndex + y * blur.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    float threshold = blur.data[indexMean];
                    output.data[indexOut] = input.data[indexIn] * scale > threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                    ++indexMean;
                }
            }
        }
        return output;
    }
}

