/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.derivative.GradientPrewitt;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.alg.filter.derivative.GradientTwo0;
import boofcv.alg.filter.derivative.GradientTwo1;
import boofcv.alg.filter.derivative.HessianFromGradient;
import boofcv.alg.filter.derivative.HessianSobel;
import boofcv.alg.filter.derivative.HessianThree;
import boofcv.alg.filter.derivative.LaplacianEdge;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class GImageDerivativeOps {
    public static <I extends ImageSingleBand, D extends ImageSingleBand> void laplace(I input, D output) {
        if (input instanceof ImageFloat32) {
            LaplacianEdge.process((ImageFloat32)input, (ImageFloat32)output);
        } else if (input instanceof ImageUInt8) {
            LaplacianEdge.process((ImageUInt8)input, (ImageSInt16)output);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
        }
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> Class<D> getDerivativeType(Class<I> imageType) {
        if (imageType == ImageFloat32.class) {
            return ImageFloat32.class;
        }
        if (imageType == ImageUInt8.class) {
            return ImageSInt16.class;
        }
        if (imageType == ImageUInt16.class) {
            return ImageSInt32.class;
        }
        throw new IllegalArgumentException("Unknown input image type: " + imageType.getSimpleName());
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> void gradient(DerivativeType type, I input, D derivX, D derivY, BorderType borderType) {
        ImageBorder<I> border = BorderType.SKIP == borderType ? null : FactoryImageBorder.single(input, borderType);
        switch (type) {
            case PREWITT: {
                if (input instanceof ImageFloat32) {
                    GradientPrewitt.process((ImageFloat32)input, (ImageFloat32)derivX, (ImageFloat32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof ImageUInt8) {
                    GradientPrewitt.process((ImageUInt8)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof ImageSInt16) {
                    GradientPrewitt.process((ImageSInt16)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case SOBEL: {
                if (input instanceof ImageFloat32) {
                    GradientSobel.process((ImageFloat32)input, (ImageFloat32)derivX, (ImageFloat32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof ImageUInt8) {
                    GradientSobel.process((ImageUInt8)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof ImageSInt16) {
                    GradientSobel.process((ImageSInt16)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case THREE: {
                if (input instanceof ImageFloat32) {
                    GradientThree.process((ImageFloat32)input, (ImageFloat32)derivX, (ImageFloat32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof ImageUInt8) {
                    GradientThree.process((ImageUInt8)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof ImageSInt16) {
                    GradientThree.process((ImageSInt16)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case TWO_0: {
                if (input instanceof ImageFloat32) {
                    GradientTwo0.process((ImageFloat32)input, (ImageFloat32)derivX, (ImageFloat32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof ImageUInt8) {
                    GradientTwo0.process((ImageUInt8)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof ImageSInt16) {
                    GradientTwo0.process((ImageSInt16)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case TWO_1: {
                if (input instanceof ImageFloat32) {
                    GradientTwo1.process((ImageFloat32)input, (ImageFloat32)derivX, (ImageFloat32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof ImageUInt8) {
                    GradientTwo1.process((ImageUInt8)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof ImageSInt16) {
                    GradientTwo1.process((ImageSInt16)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
            }
        }
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> void hessian(DerivativeType type, I input, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<I> border = BorderType.SKIP == borderType ? null : FactoryImageBorder.single(input, borderType);
        switch (type) {
            case SOBEL: {
                if (input instanceof ImageFloat32) {
                    HessianSobel.process((ImageFloat32)input, (ImageFloat32)derivXX, (ImageFloat32)derivYY, (ImageFloat32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof ImageUInt8) {
                    HessianSobel.process((ImageUInt8)input, (ImageSInt16)derivXX, (ImageSInt16)derivYY, (ImageSInt16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case THREE: {
                if (input instanceof ImageFloat32) {
                    HessianThree.process((ImageFloat32)input, (ImageFloat32)derivXX, (ImageFloat32)derivYY, (ImageFloat32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof ImageUInt8) {
                    HessianThree.process((ImageUInt8)input, (ImageSInt16)derivXX, (ImageSInt16)derivYY, (ImageSInt16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unsupported derivative type " + (Object)((Object)type));
            }
        }
    }

    public static <D extends ImageSingleBand> void hessian(DerivativeType type, D derivX, D derivY, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<D> border = BorderType.SKIP == borderType ? null : FactoryImageBorder.single(derivX, borderType);
        switch (type) {
            case PREWITT: {
                if (derivX instanceof ImageFloat32) {
                    HessianFromGradient.hessianPrewitt((ImageFloat32)derivX, (ImageFloat32)derivY, (ImageFloat32)derivXX, (ImageFloat32)derivYY, (ImageFloat32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (derivX instanceof ImageSInt16) {
                    HessianFromGradient.hessianPrewitt((ImageSInt16)derivX, (ImageSInt16)derivY, (ImageSInt16)derivXX, (ImageSInt16)derivYY, (ImageSInt16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + derivX.getClass().getSimpleName());
            }
            case SOBEL: {
                if (derivX instanceof ImageFloat32) {
                    HessianFromGradient.hessianSobel((ImageFloat32)derivX, (ImageFloat32)derivY, (ImageFloat32)derivXX, (ImageFloat32)derivYY, (ImageFloat32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (derivX instanceof ImageSInt16) {
                    HessianFromGradient.hessianSobel((ImageSInt16)derivX, (ImageSInt16)derivY, (ImageSInt16)derivXX, (ImageSInt16)derivYY, (ImageSInt16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + derivX.getClass().getSimpleName());
            }
            case THREE: {
                if (derivX instanceof ImageFloat32) {
                    HessianFromGradient.hessianThree((ImageFloat32)derivX, (ImageFloat32)derivY, (ImageFloat32)derivXX, (ImageFloat32)derivYY, (ImageFloat32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (derivX instanceof ImageSInt16) {
                    HessianFromGradient.hessianThree((ImageSInt16)derivX, (ImageSInt16)derivY, (ImageSInt16)derivXX, (ImageSInt16)derivYY, (ImageSInt16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + derivX.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unsupported derivative type " + (Object)((Object)type));
            }
        }
    }

    public static KernelBase lookupKernelX(DerivativeType type, boolean isInteger) {
        switch (type) {
            case PREWITT: {
                return GradientPrewitt.getKernelX(isInteger);
            }
            case SOBEL: {
                return GradientSobel.getKernelX(isInteger);
            }
            case THREE: {
                return GradientThree.getKernelX(isInteger);
            }
            case TWO_0: {
                return GradientTwo0.getKernelX(isInteger);
            }
            case TWO_1: {
                return GradientTwo1.getKernelX(isInteger);
            }
        }
        throw new IllegalArgumentException("Unknown kernel type: " + (Object)((Object)type));
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> AnyImageDerivative<I, D> createAnyDerivatives(DerivativeType type, Class<I> inputType, Class<D> derivType) {
        boolean isInteger = !GeneralizedImageOps.isFloatingPoint(inputType);
        KernelBase kernel = GImageDerivativeOps.lookupKernelX(type, isInteger);
        if (kernel instanceof Kernel1D) {
            return new AnyImageDerivative<I, D>((Kernel1D)kernel, inputType, derivType);
        }
        return new AnyImageDerivative<I, D>((Kernel2D)kernel, inputType, derivType);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> AnyImageDerivative<I, D> derivativeForScaleSpace(Class<I> inputType, Class<D> derivType) {
        return GImageDerivativeOps.createAnyDerivatives(DerivativeType.THREE, inputType, derivType);
    }
}

