/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid.impl;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;

public class ImplPyramidOps {
    public static void scaleImageUp(ImageFloat32 input, ImageFloat32 output, int scale, InterpolatePixelS<ImageFloat32> interp) {
        output.reshape(input.width * scale, input.height * scale);
        float fdiv = 1.0f / (float)scale;
        interp.setImage(input);
        for (int y = 0; y < output.height; ++y) {
            float inputY = (float)y * fdiv;
            int indexOutput = output.getIndex(0, y);
            for (int x = 0; x < output.width; ++x) {
                float inputX = (float)x * fdiv;
                output.data[indexOutput++] = interp.get(inputX, inputY);
            }
        }
    }

    public static void scaleDown2(ImageFloat32 input, ImageFloat32 output) {
        output.reshape(input.width / 2, input.height / 2);
        for (int y = 0; y < output.height; ++y) {
            int indexInput = 2 * y * input.stride;
            int indexOutput = y * output.stride;
            int x = 0;
            while (x < output.width) {
                output.data[indexOutput++] = input.data[indexInput];
                ++x;
                indexInput += 2;
            }
        }
    }

    public static void scaleImageUp(ImageUInt8 input, ImageUInt8 output, int scale, InterpolatePixelS<ImageUInt8> interp) {
        output.reshape(input.width * scale, input.height * scale);
        float fdiv = 1.0f / (float)scale;
        interp.setImage(input);
        for (int y = 0; y < output.height; ++y) {
            float inputY = (float)y * fdiv;
            int indexOutput = output.getIndex(0, y);
            for (int x = 0; x < output.width; ++x) {
                float inputX = (float)x * fdiv;
                output.data[indexOutput++] = (byte)interp.get(inputX, inputY);
            }
        }
    }

    public static void scaleDown2(ImageUInt8 input, ImageUInt8 output) {
        output.reshape(input.width / 2, input.height / 2);
        for (int y = 0; y < output.height; ++y) {
            int indexInput = 2 * y * input.stride;
            int indexOutput = y * output.stride;
            int x = 0;
            while (x < output.width) {
                output.data[indexOutput++] = input.data[indexInput];
                ++x;
                indexInput += 2;
            }
        }
    }
}

