/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.ConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;
import java.lang.reflect.Method;

public class GConvertImage {
    public static void convert(ImageBase input, ImageBase output) {
        if (input instanceof ImageSingleBand) {
            ImageSingleBand sb = (ImageSingleBand)input;
            if (output instanceof ImageSingleBand) {
                if (input.getClass() == output.getClass()) {
                    output.setTo(input);
                } else {
                    try {
                        Method m = ConvertImage.class.getMethod("convert", input.getClass(), output.getClass());
                        m.invoke(null, input, output);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unknown conversion");
                    }
                }
            } else if (output instanceof MultiSpectral) {
                MultiSpectral ms = (MultiSpectral)output;
                for (int i = 0; i < ms.getNumBands(); ++i) {
                    GConvertImage.convert(input, ms.getBand(i));
                }
            } else if (output instanceof ImageInterleaved) {
                ImageInterleaved il = (ImageInterleaved)output;
                for (int i = 0; i < il.getNumBands(); ++i) {
                    GImageMiscOps.insertBand(sb, i, il);
                }
            }
        } else if (input instanceof ImageInterleaved && output instanceof ImageInterleaved) {
            if (input.getClass() == output.getClass()) {
                output.setTo(input);
            } else {
                try {
                    Method m = ConvertImage.class.getMethod("convert", input.getClass(), output.getClass());
                    m.invoke(null, input, output);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unknown conversion");
                }
            }
        } else if (input instanceof MultiSpectral && output instanceof ImageSingleBand) {
            MultiSpectral mi = (MultiSpectral)input;
            ImageSingleBand so = (ImageSingleBand)output;
            if (mi.getImageType().getDataType() != so.getDataType()) {
                int w = output.width;
                int h = output.height;
                Object tmp = GeneralizedImageOps.createSingleBand(mi.getImageType().getDataType(), w, h);
                GConvertImage.average(mi, tmp);
                GConvertImage.convert(tmp, so);
            } else {
                GConvertImage.average(mi, so);
            }
        } else if (input instanceof MultiSpectral && output instanceof ImageInterleaved) {
            try {
                Method m = ConvertImage.class.getMethod("convert", input.getClass(), output.getClass());
                m.invoke(null, input, output);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unknown conversion");
            }
        } else if (input instanceof MultiSpectral && output instanceof MultiSpectral) {
            MultiSpectral mi = (MultiSpectral)input;
            MultiSpectral mo = (MultiSpectral)output;
            if (mi.getBandType() == mo.getBandType()) {
                mo.setTo(mi);
            } else {
                for (int i = 0; i < mi.getNumBands(); ++i) {
                    GConvertImage.convert(mi.getBand(i), mo.getBand(i));
                }
            }
        } else if (input instanceof ImageInterleaved && output instanceof MultiSpectral) {
            try {
                Method m = ConvertImage.class.getMethod("convert", input.getClass(), output.getClass());
                m.invoke(null, input, output);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unknown conversion");
            }
        } else if (input instanceof ImageInterleaved && output instanceof ImageSingleBand) {
            ImageInterleaved mb = (ImageInterleaved)input;
            ImageSingleBand so = (ImageSingleBand)output;
            if (mb.getImageType().getDataType() != so.getDataType()) {
                int w = output.width;
                int h = output.height;
                Object tmp = GeneralizedImageOps.createSingleBand(mb.getImageType().getDataType(), w, h);
                GConvertImage.average(mb, tmp);
                GConvertImage.convert(tmp, so);
            } else {
                GConvertImage.average(mb, so);
            }
        } else {
            String nameInput = input.getClass().getSimpleName();
            String nameOutput = output.getClass().getSimpleName();
            throw new IllegalArgumentException("Don't know how to convert between input types. " + nameInput + " " + nameOutput);
        }
    }

    public static <T extends ImageSingleBand> T average(MultiSpectral<T> input, T output) {
        Class<T> type = input.getBandType();
        if (type == ImageUInt8.class) {
            return (T)ConvertImage.average(input, (ImageUInt8)output);
        }
        if (type == ImageSInt8.class) {
            return (T)ConvertImage.average(input, (ImageSInt8)output);
        }
        if (type == ImageUInt16.class) {
            return (T)ConvertImage.average(input, (ImageUInt16)output);
        }
        if (type == ImageSInt16.class) {
            return (T)ConvertImage.average(input, (ImageSInt16)output);
        }
        if (type == ImageSInt32.class) {
            return (T)ConvertImage.average(input, (ImageSInt32)output);
        }
        if (type == ImageSInt64.class) {
            return (T)ConvertImage.average(input, (ImageSInt64)output);
        }
        if (type == ImageFloat32.class) {
            return (T)ConvertImage.average(input, (ImageFloat32)output);
        }
        if (type == ImageFloat64.class) {
            return (T)ConvertImage.average(input, (ImageFloat64)output);
        }
        throw new IllegalArgumentException("Unknown image type: " + type.getSimpleName());
    }

    public static <T extends ImageSingleBand> T average(ImageInterleaved input, T output) {
        ImageDataType type = input.getImageType().getDataType();
        if (type == ImageDataType.U8) {
            return (T)ConvertImage.average((InterleavedU8)input, (ImageUInt8)output);
        }
        if (type == ImageDataType.S8) {
            return (T)ConvertImage.average((InterleavedS8)input, (ImageSInt8)output);
        }
        if (type == ImageDataType.U16) {
            return (T)ConvertImage.average((InterleavedU16)input, (ImageUInt16)output);
        }
        if (type == ImageDataType.S16) {
            return (T)ConvertImage.average((InterleavedS16)input, (ImageSInt16)output);
        }
        if (type == ImageDataType.S32) {
            return (T)ConvertImage.average((InterleavedS32)input, (ImageSInt32)output);
        }
        if (type == ImageDataType.S64) {
            return (T)ConvertImage.average((InterleavedS64)input, (ImageSInt64)output);
        }
        if (type == ImageDataType.F32) {
            return (T)ConvertImage.average((InterleavedF32)input, (ImageFloat32)output);
        }
        if (type == ImageDataType.F64) {
            return (T)ConvertImage.average((InterleavedF64)input, (ImageFloat64)output);
        }
        throw new IllegalArgumentException("Unknown image type: " + (Object)((Object)type));
    }

    public static ImageUInt8 convert(ImageSingleBand input, double min, double max, int numValues, ImageUInt8 output) {
        if (min == 0.0 && max == 255.0 && numValues == 256) {
            if (output == null) {
                output = new ImageUInt8(input.width, input.height);
            }
            GConvertImage.convert(input, output);
            return output;
        }
        ImageDataType type = input.getImageType().getDataType();
        if (type == ImageDataType.U8) {
            return ConvertImage.convert((ImageUInt8)input, (int)min, (int)max, numValues, output);
        }
        if (type == ImageDataType.S8) {
            return ConvertImage.convert((ImageSInt8)input, (int)min, (int)max, numValues, output);
        }
        if (type == ImageDataType.U16) {
            return ConvertImage.convert((ImageUInt16)input, (int)min, (int)max, numValues, output);
        }
        if (type == ImageDataType.S16) {
            return ConvertImage.convert((ImageSInt16)input, (int)min, (int)max, numValues, output);
        }
        if (type == ImageDataType.S32) {
            return ConvertImage.convert((ImageSInt32)input, (int)min, (int)max, numValues, output);
        }
        if (type == ImageDataType.S64) {
            return ConvertImage.convert((ImageSInt64)input, (long)min, (long)max, numValues, output);
        }
        if (type == ImageDataType.F32) {
            return ConvertImage.convert((ImageFloat32)input, (float)min, (float)max, numValues, output);
        }
        if (type == ImageDataType.F64) {
            return ConvertImage.convert((ImageFloat64)input, min, max, numValues, output);
        }
        throw new IllegalArgumentException("Unknown image type: " + (Object)((Object)type));
    }
}

