/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.border;

import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_F64;
import boofcv.core.image.border.ImageBorder_IL_F32;
import boofcv.core.image.border.ImageBorder_IL_F64;
import boofcv.core.image.border.ImageBorder_IL_S32;
import boofcv.core.image.border.ImageBorder_IL_S64;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.core.image.border.ImageBorder_S64;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedInteger;
import boofcv.struct.image.InterleavedS64;
import java.util.Arrays;

public class ImageBorderValue {
    public static ImageBorder wrap(ImageSingleBand image, double value) {
        if (image.getDataType().isInteger()) {
            if (image.getDataType().getNumBits() <= 32) {
                return ImageBorderValue.wrap((ImageInteger)image, (int)value);
            }
            return ImageBorderValue.wrap((ImageSInt64)image, (long)value);
        }
        if (image.getDataType().getDataType() == Float.TYPE) {
            return ImageBorderValue.wrap((ImageFloat32)image, (float)value);
        }
        return ImageBorderValue.wrap((ImageFloat64)image, value);
    }

    public static ImageBorder wrap(ImageInterleaved image, double value) {
        if (image instanceof InterleavedF32) {
            return new Value_IL_F32((InterleavedF32)image, (float)value);
        }
        if (image instanceof InterleavedF64) {
            return new Value_IL_F64((InterleavedF64)image, value);
        }
        if (InterleavedInteger.class.isAssignableFrom(image.getClass())) {
            return new Value_IL_S32((InterleavedInteger)image, (int)value);
        }
        if (image instanceof InterleavedS64) {
            return new Value_IL_S64((InterleavedS64)image, (long)value);
        }
        throw new RuntimeException("Add support for more types");
    }

    public static ImageBorder_S64 wrap(ImageSInt64 image, long value) {
        return new Value_I64(image, value);
    }

    public static ImageBorder_F64 wrap(ImageFloat64 image, double value) {
        return new Value_F64(image, value);
    }

    public static ImageBorder_F32 wrap(ImageFloat32 image, float value) {
        return new Value_F32(image, value);
    }

    public static ImageBorder_S32 wrap(ImageInteger image, int value) {
        return new Value_I(image, value);
    }

    public static class Value_IL_S64
    extends ImageBorder_IL_S64 {
        long value;

        public Value_IL_S64(InterleavedS64 image, long value) {
            super(image);
            this.value = value;
        }

        public Value_IL_S64(long value) {
            this.value = value;
        }

        @Override
        public void getOutside(int x, int y, long[] pixel) {
            Arrays.fill(pixel, this.value);
        }

        @Override
        public void setOutside(int x, int y, long[] pixel) {
        }
    }

    public static class Value_IL_S32
    extends ImageBorder_IL_S32 {
        int value;

        public Value_IL_S32(InterleavedInteger image, int value) {
            super(image);
            this.value = value;
        }

        public Value_IL_S32(int value) {
            this.value = value;
        }

        @Override
        public void getOutside(int x, int y, int[] pixel) {
            Arrays.fill(pixel, this.value);
        }

        @Override
        public void setOutside(int x, int y, int[] pixel) {
        }
    }

    public static class Value_IL_F64
    extends ImageBorder_IL_F64 {
        double value;

        public Value_IL_F64(InterleavedF64 image, double value) {
            super(image);
            this.value = value;
        }

        public Value_IL_F64(double value) {
            this.value = value;
        }

        @Override
        public void getOutside(int x, int y, double[] pixel) {
            Arrays.fill(pixel, this.value);
        }

        @Override
        public void setOutside(int x, int y, double[] pixel) {
        }
    }

    public static class Value_IL_F32
    extends ImageBorder_IL_F32 {
        float value;

        public Value_IL_F32(InterleavedF32 image, float value) {
            super(image);
            this.value = value;
        }

        public Value_IL_F32(float value) {
            this.value = value;
        }

        @Override
        public void getOutside(int x, int y, float[] pixel) {
            Arrays.fill(pixel, this.value);
        }

        @Override
        public void setOutside(int x, int y, float[] pixel) {
        }
    }

    public static class Value_I
    extends ImageBorder_S32 {
        int value;

        public Value_I(ImageInteger image, int value) {
            super(image);
            this.value = value;
        }

        public Value_I(int value) {
            this.value = value;
        }

        @Override
        public int getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, int value) {
        }
    }

    public static class Value_F32
    extends ImageBorder_F32 {
        float value;

        public Value_F32(ImageFloat32 image, float value) {
            super(image);
            this.value = value;
        }

        public Value_F32(float value) {
            this.value = value;
        }

        @Override
        public float getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, float val) {
        }
    }

    public static class Value_F64
    extends ImageBorder_F64 {
        double value;

        public Value_F64(ImageFloat64 image, double value) {
            super(image);
            this.value = value;
        }

        public Value_F64(double value) {
            this.value = value;
        }

        @Override
        public double getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, double val) {
        }
    }

    public static class Value_I64
    extends ImageBorder_S64 {
        long value;

        public Value_I64(ImageSInt64 image, long value) {
            super(image);
            this.value = value;
        }

        public Value_I64(long value) {
            this.value = value;
        }

        @Override
        public long getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, long val) {
        }
    }
}

